/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.bootstrap;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.ObjectProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.api.transaction.TransactionFactory;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.util.StreamCloser;
import org.mule.config.bootstrap.BootstrapObjectFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.ClassUtils;
import org.mule.util.ExceptionUtils;
import org.mule.util.PropertiesUtils;
import org.mule.util.UUID;

public class SimpleRegistryBootstrap
implements Initialisable,
MuleContextAware {
    public static final String SERVICE_PATH = "META-INF/services/org/mule/config/";
    public static final String REGISTRY_PROPERTIES = "registry-bootstrap.properties";
    public String TRANSFORMER_KEY = ".transformer.";
    public String OBJECT_KEY = ".object.";
    public String SINGLE_TX = ".singletx.";
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected MuleContext context;

    @Override
    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    @Override
    public void initialise() throws InitialisationException {
        Enumeration<URL> e = ClassUtils.getResources("META-INF/services/org/mule/config/registry-bootstrap.properties", this.getClass());
        LinkedList<Properties> bootstraps = new LinkedList<Properties>();
        while (e.hasMoreElements()) {
            try {
                URL url = e.nextElement();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Reading bootstrap file: " + url.toString()));
                }
                Properties p = new Properties();
                p.load(url.openStream());
                bootstraps.add(p);
            }
            catch (Exception e1) {
                throw new InitialisationException((Throwable)e1, (Initialisable)this);
            }
        }
        int objectCounter = 1;
        int transformerCounter = 1;
        Properties transformers = new Properties();
        Properties namedObjects = new Properties();
        Properties unnamedObjects = new Properties();
        HashMap<String, String> singleTransactionFactories = new HashMap<String, String>();
        for (Properties bootstrap : bootstraps) {
            for (Map.Entry<Object, Object> entry : bootstrap.entrySet()) {
                String newKey;
                String key = (String)entry.getKey();
                if (key.contains(this.OBJECT_KEY)) {
                    newKey = key.substring(0, key.lastIndexOf(".")) + objectCounter++;
                    unnamedObjects.put(newKey, entry.getValue());
                    continue;
                }
                if (key.contains(this.TRANSFORMER_KEY)) {
                    newKey = key.substring(0, key.lastIndexOf(".")) + transformerCounter++;
                    transformers.put(newKey, entry.getValue());
                    continue;
                }
                if (key.contains(this.SINGLE_TX)) {
                    if (key.contains(".transaction.resource")) continue;
                    String transactionResourceKey = key.replace(".transaction.factory", ".transaction.resource");
                    String transactionResource = bootstrap.getProperty(transactionResourceKey);
                    if (transactionResource == null) {
                        throw new InitialisationException(CoreMessages.createStaticMessage(String.format("Theres no transaction resource specified for transaction factory %s", key)), (Initialisable)this);
                    }
                    singleTransactionFactories.put((String)entry.getValue(), transactionResource);
                    continue;
                }
                namedObjects.put(key, entry.getValue());
            }
        }
        try {
            this.registerUnnamedObjects(unnamedObjects, this.context.getRegistry());
            this.registerTransformers(transformers, this.context.getRegistry());
            this.registerObjects(namedObjects, this.context.getRegistry());
            this.registerTransactionFactories(singleTransactionFactories, this.context);
        }
        catch (Exception e1) {
            throw new InitialisationException((Throwable)e1, (Initialisable)this);
        }
    }

    private void registerTransactionFactories(Map<String, String> singleTransactionFactories, MuleContext context) throws Exception {
        for (String transactionFactoryClassName : singleTransactionFactories.keySet()) {
            String transactionResourceClassName = singleTransactionFactories.get(transactionFactoryClassName);
            context.getTransactionFactoryManager().registerTransactionFactory(Class.forName(transactionResourceClassName), (TransactionFactory)Class.forName(transactionFactoryClassName).newInstance());
        }
    }

    private void registerTransformers(Properties props, MuleRegistry registry) throws Exception {
        String name = null;
        boolean optional = false;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String transString = (String)entry.getValue();
            Class returnClass = null;
            String returnClassString = null;
            int x = transString.indexOf(",");
            if (x > -1) {
                Properties p = PropertiesUtils.getPropertiesFromString(transString.substring(x + 1), ',');
                name = p.getProperty("name", null);
                returnClassString = p.getProperty("returnClass", null);
                optional = p.containsKey("optional");
            }
            String transClass = x == -1 ? transString : transString.substring(0, x);
            try {
                Transformer trans;
                String mime = null;
                if (returnClassString != null) {
                    int i = returnClassString.indexOf(":");
                    if (i > -1) {
                        mime = returnClassString.substring(i + 1);
                        returnClassString = returnClassString.substring(0, i);
                    }
                    returnClass = returnClassString.equals("byte[]") ? byte[].class : ClassUtils.loadClass(returnClassString, this.getClass());
                }
                if (!((trans = (Transformer)ClassUtils.instanciateClass(transClass, new Object[0])) instanceof DiscoverableTransformer)) {
                    throw new RegistrationException(CoreMessages.transformerNotImplementDiscoverable(trans));
                }
                if (returnClass != null) {
                    trans.setReturnDataType(DataTypeFactory.create(returnClass, mime));
                }
                if (name != null) {
                    trans.setName(name);
                } else {
                    name = trans.getName();
                    trans.setName("_" + name);
                }
                registry.registerTransformer(trans);
            }
            catch (InvocationTargetException itex) {
                Throwable cause = ExceptionUtils.getCause((Throwable)itex);
                if (cause instanceof NoClassDefFoundError && optional) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Ignoring optional transformer: " + transClass));
                    }
                }
                throw new Exception(cause);
            }
            catch (NoClassDefFoundError ncdfe) {
                if (optional) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Ignoring optional transformer: " + transClass));
                    }
                }
                throw ncdfe;
            }
            catch (ClassNotFoundException cnfe) {
                if (optional) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Ignoring optional transformer: " + transClass));
                    }
                }
                throw cnfe;
            }
            name = null;
            returnClass = null;
        }
    }

    private void registerObjects(Properties props, Registry registry) throws Exception {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.registerObject((String)entry.getKey(), (String)entry.getValue(), registry);
        }
        props.clear();
    }

    private void registerUnnamedObjects(Properties props, Registry registry) throws Exception {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = String.format("%s#%s", entry.getKey(), UUID.getUUID());
            this.registerObject(key, (String)entry.getValue(), registry);
        }
        props.clear();
    }

    private void registerObject(String key, String value, Registry registry) throws Exception {
        boolean optional = false;
        String className = null;
        try {
            int x = value.indexOf(",");
            if (x > -1) {
                Properties p = PropertiesUtils.getPropertiesFromString(value.substring(x + 1), ',');
                optional = p.containsKey("optional");
                className = value.substring(0, x);
            } else {
                className = value;
            }
            Object o = ClassUtils.instanciateClass(className, new Object[0]);
            Class<Object> meta = Object.class;
            if (o instanceof ObjectProcessor) {
                meta = ObjectProcessor.class;
            } else if (o instanceof StreamCloser) {
                meta = StreamCloser.class;
            } else if (o instanceof BootstrapObjectFactory) {
                o = ((BootstrapObjectFactory)o).create();
            }
            registry.registerObject(key, o, meta);
        }
        catch (InvocationTargetException itex) {
            Throwable cause = ExceptionUtils.getCause((Throwable)itex);
            if (cause instanceof NoClassDefFoundError && optional) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Ignoring optional object: " + className));
                }
            }
            throw new Exception(cause);
        }
        catch (NoClassDefFoundError ncdfe) {
            if (optional) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Ignoring optional object: " + className));
                }
            }
            throw ncdfe;
        }
        catch (ClassNotFoundException cnfe) {
            if (optional) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Ignoring optional object: " + className));
                }
            }
            throw cnfe;
        }
    }
}

