/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.registry;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.registry.ServiceDescriptor;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

public abstract class AbstractServiceDescriptor
implements ServiceDescriptor {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected String service;

    public AbstractServiceDescriptor(String service) {
        this.service = service;
    }

    @Override
    public String getService() {
        return this.service;
    }

    protected String removeProperty(String name, Properties properties) {
        String temp = (String)properties.remove(name);
        if (StringUtils.isEmpty((String)StringUtils.trim((String)temp))) {
            return null;
        }
        return temp;
    }

    protected Class<?> removeClassProperty(String name, Properties properties) throws ClassNotFoundException {
        String clazz = this.removeProperty(name, properties);
        if (clazz == null) {
            return null;
        }
        return ClassUtils.loadClass(clazz, this.getClass());
    }

    public static class Key {
        private final Map<?, ?> overrides;
        private final String service;

        public Key(String service, Map<?, ?> overrides) {
            this.overrides = overrides;
            this.service = service;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (this.overrides != null ? !((Object)this.overrides).equals(key.overrides) : key.overrides != null) {
                return false;
            }
            return this.service.equals(key.service);
        }

        public int hashCode() {
            return 29 * (this.overrides != null ? ((Object)this.overrides).hashCode() : 0) + (this.service != null ? this.service.hashCode() : 0);
        }

        public String getKey() {
            return this.service + ":" + Integer.toString(this.hashCode());
        }
    }
}

