/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.timer;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import org.mule.util.timer.TimeEvent;
import org.mule.util.timer.TimeEventListener;

public class EventTimerTask
extends TimerTask {
    private List listeners = null;
    private String name = null;
    private boolean started = true;

    public EventTimerTask(TimeEventListener listener) {
        this.addListener(listener);
        this.name = "EventTimerTask." + this.hashCode();
    }

    public EventTimerTask(TimeEventListener listener, String name) {
        this.addListener(listener);
        this.name = name;
    }

    @Override
    public void run() {
        TimeEvent event = new TimeEvent(this, this.getName(), this.scheduledExecutionTime());
        this.fireTimerEvent(event);
    }

    public String getName() {
        return this.name;
    }

    public void removeListener(TimeEventListener listener) {
        if (this.listeners != null && this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void removeAllListeners() {
        this.listeners = new ArrayList();
    }

    public void addListener(TimeEventListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
            this.listeners.add(listener);
        } else if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    protected void fireTimerEvent(TimeEvent event) {
        if (this.listeners != null && this.started) {
            int count = this.listeners.size();
            for (int i = 0; i < count; ++i) {
                ((TimeEventListener)this.listeners.get(i)).timeExpired(event);
            }
        }
    }

    public void stop() {
        this.started = false;
    }

    public void start() {
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }
}

