/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.util.UUID;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueInfo;
import org.mule.util.queue.QueueKey;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.QueueSession;
import org.mule.util.queue.QueueTransactionContext;
import org.mule.util.queue.TransactionalQueueSession;
import org.mule.util.store.QueuePersistenceObjectStore;
import org.mule.util.xa.AbstractTransactionContext;
import org.mule.util.xa.AbstractXAResourceManager;
import org.mule.util.xa.ResourceManagerException;
import org.mule.util.xa.ResourceManagerSystemException;

public class TransactionalQueueManager
extends AbstractXAResourceManager
implements QueueManager,
MuleContextAware {
    private Map<String, QueueInfo> queues = new HashMap<String, QueueInfo>();
    private QueueConfiguration defaultQueueConfiguration;
    private MuleContext muleContext;
    private Set<ListableObjectStore> stores = new HashSet<ListableObjectStore>();

    @Override
    public synchronized QueueSession getQueueSession() {
        return new TransactionalQueueSession(this, this);
    }

    @Override
    public synchronized void setDefaultQueueConfiguration(QueueConfiguration config) {
        this.defaultQueueConfiguration = config;
        this.addStore(config.objectStore);
    }

    @Override
    public synchronized void setQueueConfiguration(String queueName, QueueConfiguration config) {
        this.getQueue(queueName, config).setConfig(config);
        this.addStore(config.objectStore);
    }

    protected synchronized QueueInfo getQueue(String name) {
        return this.getQueue(name, this.defaultQueueConfiguration);
    }

    protected synchronized QueueInfo getQueue(String name, QueueConfiguration config) {
        QueueInfo q = this.queues.get(name);
        if (q == null) {
            q = new QueueInfo(name, this.muleContext, config);
            this.queues.put(name, q);
        }
        return q;
    }

    public synchronized QueueInfo getQueueInfo(String name) {
        QueueInfo q = this.queues.get(name);
        return q == null ? q : new QueueInfo(q);
    }

    @Override
    protected void doStart() throws ResourceManagerSystemException {
        this.findAllStores();
        for (ListableObjectStore store : this.stores) {
            try {
                store.open();
            }
            catch (ObjectStoreException e) {
                throw new ResourceManagerSystemException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean shutdown(int mode, long timeoutMSecs) {
        this.findAllStores();
        for (ListableObjectStore store : this.stores) {
            try {
                store.close();
            }
            catch (ObjectStoreException e) {
                this.logger.error((Object)"Error closing persistent store", (Throwable)e);
            }
        }
        TransactionalQueueManager transactionalQueueManager = this;
        synchronized (transactionalQueueManager) {
            this.queues.clear();
        }
        return super.shutdown(mode, timeoutMSecs);
    }

    @Override
    protected void recover() throws ResourceManagerSystemException {
        this.findAllStores();
        for (ListableObjectStore store : this.stores) {
            try {
                if (store instanceof QueuePersistenceObjectStore) {
                    ((QueuePersistenceObjectStore)store).removeUnhealthyFiles();
                }
                List<Serializable> keys = store.allKeys();
                for (Serializable key : keys) {
                    if (!(key instanceof QueueKey)) continue;
                    QueueKey queueKey = (QueueKey)key;
                    QueueInfo queue = this.getQueue(queueKey.queueName);
                    if (!queue.isQueueTransient()) continue;
                    queue.putNow(queueKey.id);
                }
            }
            catch (Exception e) {
                throw new ResourceManagerSystemException(e);
            }
        }
    }

    @Override
    protected AbstractTransactionContext createTransactionContext(Object session) {
        return new QueueTransactionContext(this);
    }

    @Override
    protected void doBegin(AbstractTransactionContext context) {
    }

    @Override
    protected int doPrepare(AbstractTransactionContext context) {
        return 0;
    }

    @Override
    protected void doCommit(AbstractTransactionContext context) throws ResourceManagerException {
        context.doCommit();
    }

    protected Serializable doStore(QueueInfo queue, Serializable object) throws ObjectStoreException {
        ListableObjectStore<Serializable> store = queue.getStore();
        String id = this.muleContext == null ? UUID.getUUID() : this.muleContext.getUniqueIdString();
        QueueKey key = new QueueKey(queue.getName(), (Serializable)((Object)id));
        store.store(key, object);
        return id;
    }

    protected void doRemove(QueueInfo queue, Serializable id) throws ObjectStoreException {
        ListableObjectStore<Serializable> store = queue.getStore();
        QueueKey key = new QueueKey(queue.getName(), id);
        store.remove(key);
    }

    protected Serializable doLoad(QueueInfo queue, Serializable id) throws ObjectStoreException {
        ListableObjectStore<Serializable> store = queue.getStore();
        QueueKey key = new QueueKey(queue.getName(), id);
        return store.retrieve(key);
    }

    @Override
    protected void doRollback(AbstractTransactionContext context) throws ResourceManagerException {
        context.doRollback();
    }

    protected synchronized void findAllStores() {
        if (this.muleContext != null) {
            for (ListableObjectStore store : this.muleContext.getRegistry().lookupByType(ListableObjectStore.class).values()) {
                this.addStore(store);
            }
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    private void addStore(ListableObjectStore<?> store) {
        this.stores.add(store);
    }
}

