/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;

public class ParseTemplateTransformer
extends AbstractMessageTransformer {
    private String location;
    private String template;

    public ParseTemplateTransformer() {
        this.registerSourceType(DataTypeFactory.OBJECT);
        this.setReturnDataType(DataTypeFactory.OBJECT);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.loadTemplate();
    }

    private void loadTemplate() throws InitialisationException {
        try {
            if (this.location == null) {
                throw new IllegalArgumentException("Location cannot be null");
            }
            this.template = IOUtils.getResourceAsString(this.location, this.getClass());
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        if (this.template == null) {
            throw new IllegalArgumentException("Template cannot be null");
        }
        return this.muleContext.getExpressionManager().parse(this.template, message);
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

