/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.mule.api.MuleEvent;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.MessageSequence;
import org.mule.routing.outbound.AbstractMessageSequenceSplitter;
import org.mule.routing.outbound.ArrayMessageSequence;
import org.mule.routing.outbound.CollectionMessageSequence;
import org.mule.routing.outbound.IteratorMessageSequence;

public class CollectionSplitter
extends AbstractMessageSequenceSplitter {
    @Override
    protected MessageSequence<?> splitMessageIntoSequence(MuleEvent event) {
        Object payload = event.getMessage().getPayload();
        if (payload instanceof MessageSequence) {
            return (MessageSequence)payload;
        }
        if (payload instanceof Iterator) {
            return new IteratorMessageSequence((Iterator)payload);
        }
        if (payload instanceof Collection) {
            return new CollectionMessageSequence(new LinkedList((Collection)payload));
        }
        if (payload instanceof Iterable) {
            return new IteratorMessageSequence(((Iterable)payload).iterator());
        }
        if (payload instanceof Object[]) {
            return new ArrayMessageSequence((Object[])payload);
        }
        throw new IllegalArgumentException(CoreMessages.objectNotOfCorrectType(payload.getClass(), new Class[]{Iterable.class, Iterator.class, MessageSequence.class, Collection.class}).getMessage());
    }
}

