/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.api.registry.RegistryBroker;
import org.mule.lifecycle.RegistryBrokerLifecycleManager;

public abstract class AbstractRegistryBroker
implements RegistryBroker {
    protected RegistryBrokerLifecycleManager lifecycleManager;

    public AbstractRegistryBroker(MuleContext muleContext) {
        this.lifecycleManager = new RegistryBrokerLifecycleManager("mule.registry.broker", (Registry)this, muleContext);
    }

    @Override
    public void initialise() throws InitialisationException {
        this.lifecycleManager.fireInitialisePhase(new LifecycleCallback<AbstractRegistryBroker>(){

            @Override
            public void onTransition(String phaseName, AbstractRegistryBroker broker) throws MuleException {
                for (Registry registry : broker.getRegistries()) {
                    registry.initialise();
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.lifecycleManager.fireDisposePhase(new LifecycleCallback<AbstractRegistryBroker>(){

            @Override
            public void onTransition(String phaseName, AbstractRegistryBroker broker) throws MuleException {
                for (Registry registry : broker.getRegistries()) {
                    registry.dispose();
                }
            }
        });
    }

    @Override
    public void fireLifecycle(String phase) throws LifecycleException {
        if ("initialise".equals(phase)) {
            this.initialise();
        } else if ("dispose".equals(phase)) {
            this.dispose();
        } else {
            this.lifecycleManager.fireLifecycle(phase);
            for (Registry registry : this.getRegistries()) {
                registry.fireLifecycle(phase);
            }
        }
    }

    @Override
    public String getRegistryId() {
        return this.toString();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    protected abstract Collection<Registry> getRegistries();

    @Override
    public <T> T get(String key) {
        return this.lookupObject(key);
    }

    @Override
    public <T> T lookupObject(String key) {
        T obj = null;
        Iterator<Registry> it = this.getRegistries().iterator();
        while (obj == null && it.hasNext()) {
            obj = it.next().lookupObject(key);
        }
        return obj;
    }

    @Override
    public <T> T lookupObject(Class<T> type) throws RegistrationException {
        for (Registry registry : this.getRegistries()) {
            T object = registry.lookupObject(type);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @Override
    public <T> Collection<T> lookupObjects(Class<T> type) {
        ArrayList<T> objects = new ArrayList<T>();
        Iterator<Registry> it = this.getRegistries().iterator();
        while (it.hasNext()) {
            objects.addAll(it.next().lookupObjects(type));
        }
        return objects;
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        HashMap<String, T> results = new HashMap<String, T>();
        for (Registry registry : this.getRegistries()) {
            results.putAll(registry.lookupByType(type));
        }
        return results;
    }

    @Override
    public <T> Collection<T> lookupObjectsForLifecycle(Class<T> type) {
        ArrayList<T> objects = new ArrayList<T>();
        Iterator<Registry> it = this.getRegistries().iterator();
        while (it.hasNext()) {
            objects.addAll(it.next().lookupObjectsForLifecycle(type));
        }
        return objects;
    }

    @Override
    public void registerObject(String key, Object value) throws RegistrationException {
        this.registerObject(key, value, null);
    }

    @Override
    public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        for (Registry reg : this.getRegistries()) {
            if (reg.isReadOnly()) continue;
            reg.registerObject(key, value, metadata);
            break;
        }
    }

    public void registerObjects(Map objects) throws RegistrationException {
        for (Object key : objects.keySet()) {
            this.registerObject((String)key, objects.get(key));
        }
    }

    @Override
    public void unregisterObject(String key) throws RegistrationException {
        this.unregisterObject(key, null);
    }

    @Override
    public void unregisterObject(String key, Object metadata) throws RegistrationException {
        for (Registry reg : this.getRegistries()) {
            if (reg.isReadOnly() || reg.lookupObject(key) == null) continue;
            reg.unregisterObject(key, metadata);
            break;
        }
    }
}

