/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import java.util.Map;
import java.util.Set;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.RegistrationException;
import org.mule.el.context.AbstractMapContext;

public class AppContext {
    protected MuleContext muleContext;

    public AppContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public String getName() {
        return this.muleContext.getConfiguration().getId();
    }

    public String getWorkDir() {
        return this.muleContext.getConfiguration().getWorkingDirectory();
    }

    public String getEncoding() {
        return this.muleContext.getConfiguration().getDefaultEncoding();
    }

    public boolean isStandalone() {
        return this.muleContext.getConfiguration().isStandalone();
    }

    public Map<String, Object> getRegistry() {
        return new RegistryWrapperMap(this.muleContext.getRegistry());
    }

    private static class RegistryWrapperMap
    extends AbstractMapContext<String, Object> {
        private MuleRegistry registry;

        public RegistryWrapperMap(MuleRegistry registry) {
            this.registry = registry;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public Object get(Object key) {
            if (!(key instanceof String)) {
                return null;
            }
            return this.registry.get((String)key);
        }

        @Override
        public Object put(String key, Object value) {
            try {
                this.registry.registerObject(key, value);
            }
            catch (RegistrationException e) {
                throw new MuleRuntimeException(e);
            }
            return value;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
                try {
                    this.registry.registerObject(entry.getKey(), entry.getValue());
                }
                catch (RegistrationException e) {
                    throw new MuleRuntimeException(e);
                }
            }
        }

        @Override
        public Object remove(Object key) {
            if (!(key instanceof String)) {
                return null;
            }
            Object value = this.registry.lookupObject((String)key);
            if (value != null) {
                try {
                    this.registry.unregisterObject((String)key);
                }
                catch (RegistrationException e) {
                    throw new MuleRuntimeException(e);
                }
            }
            return value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }
    }
}

