/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import java.util.Collections;
import org.apache.commons.lang.Validate;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.routing.filter.Filter;
import org.mule.api.source.MessageSource;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.AbstractConfigurationPattern;
import org.mule.expression.ExpressionConfig;
import org.mule.expression.transformers.ExpressionArgument;
import org.mule.expression.transformers.ExpressionTransformer;
import org.mule.message.DefaultExceptionPayload;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.ResponseMessageProcessorAdapter;
import org.mule.routing.ChoiceRouter;
import org.mule.util.StringUtils;

public class Validator
extends AbstractConfigurationPattern {
    private final OutboundEndpoint outboundEndpoint;
    private final Filter validationFilter;
    private final String ackExpression;
    private final String nackExpression;
    private final String errorExpression;

    public Validator(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint, Filter validationFilter, String ackExpression, String nackExpression) {
        this(name, muleContext, messageSource, outboundEndpoint, validationFilter, ackExpression, nackExpression, null);
    }

    public Validator(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint, Filter validationFilter, String ackExpression, String nackExpression, String errorExpression) {
        super(name, muleContext, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        Validate.notNull((Object)messageSource, (String)"messageSource can't be null");
        Validate.notNull((Object)outboundEndpoint, (String)"outboundEndpoint can't be null");
        Validate.notNull((Object)validationFilter, (String)"validationFilter can't be null");
        Validate.notEmpty((String)ackExpression, (String)"ackExpression can't be empty");
        Validate.notEmpty((String)nackExpression, (String)"nackExpression can't be empty");
        this.messageSource = messageSource;
        this.outboundEndpoint = outboundEndpoint;
        this.validationFilter = validationFilter;
        this.ackExpression = ackExpression;
        this.nackExpression = nackExpression;
        this.errorExpression = errorExpression;
    }

    @Override
    protected void configureMessageProcessorsBeforeTransformation(MessageProcessorChainBuilder builder) {
    }

    @Override
    protected void configureMessageProcessorsAfterTransformation(MessageProcessorChainBuilder builder) {
        ErrorAwareEventReturningMessageProcessor outboundMessageProcessor = new ErrorAwareEventReturningMessageProcessor();
        outboundMessageProcessor.setListener(this.outboundEndpoint);
        ResponseMessageProcessorAdapter ackResponseMessageProcessor = new ResponseMessageProcessorAdapter();
        ackResponseMessageProcessor.setListener(outboundMessageProcessor);
        ackResponseMessageProcessor.setProcessor(this.getExpressionTransformer(this.getName() + "-ack-expression", this.ackExpression));
        AbstractInterceptingMessageProcessor validRouteMessageProcessor = ackResponseMessageProcessor;
        if (this.hasErrorExpression()) {
            ErrorExpressionTransformerMessageProcessor errorResponseMessageProcessor = new ErrorExpressionTransformerMessageProcessor(this.getExpressionTransformer(this.getName() + "-error-expression", this.errorExpression));
            errorResponseMessageProcessor.setListener(ackResponseMessageProcessor);
            validRouteMessageProcessor = errorResponseMessageProcessor;
        }
        ChoiceRouter choiceRouter = new ChoiceRouter();
        choiceRouter.addRoute(validRouteMessageProcessor, this.validationFilter);
        choiceRouter.setDefaultRoute(this.getExpressionTransformer(this.getName() + "-nack-expression", this.nackExpression));
        builder.chain(choiceRouter);
    }

    @Override
    protected void validateConstruct() throws FlowConstructInvalidException {
        super.validateConstruct();
        this.validateMessageSource();
        this.validateOutboundEndpoint();
        this.validateExpression(this.ackExpression);
        this.validateExpression(this.nackExpression);
        if (this.hasErrorExpression()) {
            this.validateExpression(this.errorExpression);
        }
    }

    private void validateMessageSource() throws FlowConstructInvalidException {
        if (this.messageSource instanceof InboundEndpoint && !((InboundEndpoint)this.messageSource).getExchangePattern().equals((Object)MessageExchangePattern.REQUEST_RESPONSE)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("Validator only works with a request-response inbound endpoint."), this);
        }
    }

    private void validateOutboundEndpoint() throws FlowConstructInvalidException {
        if (this.hasErrorExpression() && !this.outboundEndpoint.getExchangePattern().equals((Object)MessageExchangePattern.REQUEST_RESPONSE)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("Validator with an error expression only works with a request-response outbound endpoint."), this);
        }
    }

    protected boolean hasErrorExpression() {
        return StringUtils.isNotBlank((String)this.errorExpression);
    }

    private void validateExpression(String expression) throws FlowConstructInvalidException {
        if (!this.muleContext.getExpressionManager().isExpression(expression)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("Invalid expression in Validator: " + expression), this);
        }
    }

    private ExpressionTransformer getExpressionTransformer(String name, String expression) {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.parse(expression);
        ExpressionArgument expressionArgument = new ExpressionArgument(name, expressionConfig, false);
        expressionArgument.setMuleContext(this.muleContext);
        ExpressionTransformer expressionTransformer = new ExpressionTransformer();
        expressionTransformer.setMuleContext(this.muleContext);
        expressionTransformer.addArgument(expressionArgument);
        try {
            expressionTransformer.initialise();
        }
        catch (InitialisationException ie) {
            throw new MuleRuntimeException(ie);
        }
        return expressionTransformer;
    }

    private static ExceptionPayload getExceptionPayload(MuleEvent event) {
        if (event == null) {
            return null;
        }
        MuleMessage message = event.getMessage();
        if (message == null) {
            return null;
        }
        return message.getExceptionPayload();
    }

    @Override
    public String getConstructType() {
        return "Validator";
    }

    private static class ErrorAwareEventReturningMessageProcessor
    extends AbstractInterceptingMessageProcessor {
        private ErrorAwareEventReturningMessageProcessor() {
        }

        @Override
        public MuleEvent process(MuleEvent event) throws MuleException {
            MuleEvent result = RequestContext.setEvent(event);
            try {
                MuleEvent nextResult = super.processNext(event);
                ExceptionPayload nextResultMessageExceptionPayload = Validator.getExceptionPayload(nextResult);
                if (nextResultMessageExceptionPayload != null) {
                    result.getMessage().setExceptionPayload(nextResultMessageExceptionPayload);
                }
            }
            catch (MuleException me) {
                this.logger.error((Object)me);
                result.getMessage().setExceptionPayload(new DefaultExceptionPayload(me));
            }
            return result;
        }
    }

    private static class ErrorExpressionTransformerMessageProcessor
    extends AbstractInterceptingMessageProcessor {
        private final ExpressionTransformer errorExpressionTransformer;

        public ErrorExpressionTransformerMessageProcessor(ExpressionTransformer errorExpressionTransformer) {
            this.errorExpressionTransformer = errorExpressionTransformer;
        }

        @Override
        public MuleEvent process(MuleEvent event) throws MuleException {
            MuleEvent nextResult = super.processNext(event);
            ExceptionPayload nextResultMessageExceptionPayload = Validator.getExceptionPayload(nextResult);
            if (nextResultMessageExceptionPayload != null) {
                return this.errorExpressionTransformer.process(event);
            }
            return nextResult;
        }
    }
}

