/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.config.ExceptionReader;
import org.mule.api.registry.ServiceType;
import org.mule.config.DefaultExceptionReader;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.MuleExceptionReader;
import org.mule.config.NamingExceptionReader;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.ClassUtils;
import org.mule.util.MapUtils;

public final class ExceptionHelper {
    public static final String ERROR_CODE_PROPERTY = "error.code.property";
    protected static final Log logger = LogFactory.getLog(ExceptionHelper.class);
    private static String J2SE_VERSION = "";
    private static final String J2EE_VERSION = "1.3ee";
    private static Properties errorDocs = new Properties();
    private static Properties errorCodes = new Properties();
    private static Map reverseErrorCodes = null;
    private static Map errorMappings = new HashMap();
    private static int exceptionThreshold = 0;
    private static boolean verbose = true;
    private static boolean initialised = false;
    private static List<ExceptionReader> exceptionReaders = new ArrayList<ExceptionReader>();
    private static ExceptionReader defaultExceptionReader = new DefaultExceptionReader();

    private ExceptionHelper() {
    }

    private static void initialise() {
        try {
            if (initialised) {
                return;
            }
            ExceptionHelper.registerExceptionReader(new MuleExceptionReader());
            ExceptionHelper.registerExceptionReader(new NamingExceptionReader());
            J2SE_VERSION = System.getProperty("java.specification.version");
            String name = "META-INF/services/" + ServiceType.EXCEPTION.getPath() + "/mule-exception-codes.properties";
            InputStream in = ExceptionHelper.class.getClassLoader().getResourceAsStream(name);
            if (in == null) {
                throw new IllegalArgumentException("Failed to load resource: " + name);
            }
            errorCodes.load(in);
            in.close();
            reverseErrorCodes = MapUtils.invertMap((Map)errorCodes);
            name = "META-INF/services/" + ServiceType.EXCEPTION.getPath() + "/mule-exception-config.properties";
            in = ExceptionHelper.class.getClassLoader().getResourceAsStream(name);
            if (in == null) {
                throw new IllegalArgumentException("Failed to load resource: " + name);
            }
            errorDocs.load(in);
            in.close();
            initialised = true;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.failedToLoad("Exception resources"), (Throwable)e);
        }
    }

    public static int getErrorCode(Class exception) {
        String code = errorCodes.getProperty(exception.getName(), "-1");
        return Integer.parseInt(code);
    }

    public static Class getErrorClass(int code) {
        String key = String.valueOf(code);
        Object clazz = reverseErrorCodes.get(key);
        if (clazz == null) {
            return null;
        }
        if (clazz instanceof Class) {
            return (Class)clazz;
        }
        try {
            clazz = ClassUtils.loadClass(clazz.toString(), ExceptionHelper.class);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        reverseErrorCodes.put(key, clazz);
        return (Class)clazz;
    }

    private static Properties getErrorMappings(String protocol) {
        Object m = errorMappings.get(protocol);
        if (m != null) {
            if (m instanceof Properties) {
                return (Properties)m;
            }
            return null;
        }
        String name = "META-INF/services/" + ServiceType.EXCEPTION.getPath() + "/" + protocol + "-exception-mappings.properties";
        InputStream in = ExceptionHelper.class.getClassLoader().getResourceAsStream(name);
        if (in == null) {
            errorMappings.put(protocol, "not found");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to load error mappings from: " + name + " This may be because there are no error code mappings for protocol: " + protocol));
            }
            return null;
        }
        Properties p = new Properties();
        try {
            p.load(in);
            in.close();
        }
        catch (IOException iox) {
            throw new IllegalArgumentException("Failed to load resource: " + name);
        }
        errorMappings.put(protocol, p);
        return p;
    }

    public static String getErrorCodePropertyName(String protocol) {
        Properties mappings = ExceptionHelper.getErrorMappings(protocol = protocol.toLowerCase());
        if (mappings == null) {
            return null;
        }
        return mappings.getProperty(ERROR_CODE_PROPERTY);
    }

    public static String getErrorMapping(String protocol, Class exception) {
        Properties mappings = ExceptionHelper.getErrorMappings(protocol = protocol.toLowerCase());
        if (mappings == null) {
            logger.info((Object)("No mappings found for protocol: " + protocol));
            return String.valueOf(ExceptionHelper.getErrorCode(exception));
        }
        Class clazz = exception;
        String code = null;
        while (!clazz.equals(Object.class)) {
            code = mappings.getProperty(clazz.getName());
            if (code == null) {
                clazz = clazz.getSuperclass();
                continue;
            }
            return code;
        }
        code = String.valueOf(ExceptionHelper.getErrorCode(exception));
        return mappings.getProperty(code, code);
    }

    public static String getJavaDocUrl(Class<?> exception) {
        return ExceptionHelper.getDocUrl("javadoc.", exception.getName());
    }

    public static String getDocUrl(Class<?> exception) {
        return ExceptionHelper.getDocUrl("doc.", exception.getName());
    }

    private static String getDocUrl(String prefix, String packageName) {
        String url;
        String key = prefix;
        if (packageName.startsWith("java.") || packageName.startsWith("javax.")) {
            key = key + J2SE_VERSION;
        }
        if ((url = ExceptionHelper.getUrl(key, packageName)) == null && (packageName.startsWith("java.") || packageName.startsWith("javax."))) {
            key = prefix + J2EE_VERSION;
            url = ExceptionHelper.getUrl(key, packageName);
        }
        if (url != null) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            String s = packageName.replaceAll("[.]", "/");
            s = s + ".html";
            url = url + s;
        }
        return url;
    }

    private static String getUrl(String key, String packageName) {
        String url = null;
        if (!key.endsWith(".")) {
            key = key + ".";
        }
        while (packageName.length() > 0 && (url = errorDocs.getProperty(key + packageName, null)) == null) {
            int i = packageName.lastIndexOf(".");
            if (i == -1) {
                packageName = "";
                continue;
            }
            packageName = packageName.substring(0, i);
        }
        return url;
    }

    public static Throwable getRootException(Throwable t) {
        Throwable cause = t;
        Throwable root = null;
        while (cause != null) {
            root = cause;
            if (t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
        }
        return DefaultMuleConfiguration.fullStackTraces ? root : ExceptionHelper.sanitize(root);
    }

    public static Throwable getNonMuleException(Throwable t) {
        if (!(t instanceof MuleException)) {
            return t;
        }
        Throwable cause = t;
        while (cause != null && t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause)) && cause instanceof MuleException) {
        }
        return cause instanceof MuleException ? null : cause;
    }

    public static Throwable sanitizeIfNeeded(Throwable t) {
        return DefaultMuleConfiguration.fullStackTraces ? t : ExceptionHelper.sanitize(t);
    }

    public static Throwable sanitize(Throwable t) {
        if (t == null) {
            return null;
        }
        StackTraceElement[] trace = t.getStackTrace();
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
        for (StackTraceElement stackTraceElement : trace) {
            if (ExceptionHelper.isMuleInternalClass(stackTraceElement.getClassName())) continue;
            newTrace.add(stackTraceElement);
        }
        StackTraceElement[] clean = new StackTraceElement[newTrace.size()];
        newTrace.toArray(clean);
        t.setStackTrace(clean);
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            ExceptionHelper.sanitize(cause);
        }
        return t;
    }

    public static Throwable summarise(Throwable t, int depth) {
        t = ExceptionHelper.sanitize(t);
        StackTraceElement[] trace = t.getStackTrace();
        int newStackDepth = Math.min(trace.length, depth);
        StackTraceElement[] newTrace = new StackTraceElement[newStackDepth];
        System.arraycopy(trace, 0, newTrace, 0, newStackDepth);
        t.setStackTrace(newTrace);
        return t;
    }

    private static boolean isMuleInternalClass(String className) {
        for (String mulePackage : DefaultMuleConfiguration.stackTraceFilter) {
            if (!className.startsWith(mulePackage)) continue;
            return true;
        }
        return false;
    }

    public static Throwable getRootParentException(Throwable t) {
        Throwable cause = t;
        Throwable parent = t;
        while (cause != null) {
            if (cause.getCause() == null) {
                return parent;
            }
            parent = cause;
            if (t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
            break;
        }
        return t;
    }

    public static MuleException getRootMuleException(Throwable t) {
        Throwable cause = t;
        MuleException exception = null;
        while (cause != null) {
            if (cause instanceof MuleException) {
                exception = (MuleException)cause;
            }
            Throwable tempCause = ExceptionHelper.getExceptionReader(cause).getCause(cause);
            cause = DefaultMuleConfiguration.fullStackTraces ? tempCause : ExceptionHelper.sanitize(tempCause);
            if (t != cause) continue;
            break;
        }
        return exception;
    }

    public static List getExceptionsAsList(Throwable t) {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        Throwable cause = t;
        while (cause != null) {
            exceptions.add(0, cause);
            if (t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
            break;
        }
        return exceptions;
    }

    public static Map getExceptionInfo(Throwable t) {
        HashMap info = new HashMap();
        Throwable cause = t;
        while (cause != null) {
            info.putAll(ExceptionHelper.getExceptionReader(cause).getInfo(cause));
            if (t != (cause = ExceptionHelper.getExceptionReader(cause).getCause(cause))) continue;
            break;
        }
        return info;
    }

    public static String getExceptionStack(Throwable t) {
        StringBuffer buf = new StringBuffer();
        List exceptions = ExceptionHelper.getExceptionsAsList(t);
        int i = 1;
        Iterator iterator = exceptions.iterator();
        while (iterator.hasNext()) {
            if (i > exceptionThreshold && exceptionThreshold > 0) {
                buf.append("(").append(exceptions.size() - i + 1).append(" more...)");
                break;
            }
            Throwable throwable = (Throwable)iterator.next();
            ExceptionReader er = ExceptionHelper.getExceptionReader(throwable);
            buf.append(i).append(". ").append(er.getMessage(throwable)).append(" (");
            buf.append(throwable.getClass().getName()).append(")\n");
            if (verbose && throwable.getStackTrace().length > 0) {
                StackTraceElement e = throwable.getStackTrace()[0];
                buf.append("  ").append(e.getClassName()).append(":").append(e.getLineNumber()).append(" (").append(ExceptionHelper.getJavaDocUrl(throwable.getClass())).append(")\n");
            }
            ++i;
        }
        return buf.toString();
    }

    public static void registerExceptionReader(ExceptionReader reader) {
        exceptionReaders.add(reader);
    }

    public static <T> T traverseCauseHierarchy(Throwable e, ExceptionEvaluator<T> evaluator) {
        LinkedList<Throwable> exceptions = new LinkedList<Throwable>();
        exceptions.add(e);
        while (e.getCause() != null && !e.getCause().equals(e)) {
            exceptions.addFirst(e.getCause());
            e = e.getCause();
        }
        for (Throwable exception : exceptions) {
            T value = evaluator.evaluate(exception);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static ExceptionReader getExceptionReader(Throwable t) {
        for (ExceptionReader exceptionReader : exceptionReaders) {
            if (!exceptionReader.getExceptionType().isInstance(t)) continue;
            return exceptionReader;
        }
        return defaultExceptionReader;
    }

    public static String writeException(Throwable t) {
        ExceptionReader er = ExceptionHelper.getExceptionReader(t);
        StringBuffer msg = new StringBuffer();
        msg.append(er.getMessage(t)).append(". Type: ").append(t.getClass());
        return msg.toString();
    }

    public static <T extends Throwable> T unwrap(T t) {
        if (t instanceof InvocationTargetException) {
            return (T)((InvocationTargetException)t).getTargetException();
        }
        return t;
    }

    static {
        ExceptionHelper.initialise();
    }

    public static interface ExceptionEvaluator<T> {
        public T evaluate(Throwable var1);
    }
}

