/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgrapht.graph.DirectedMultigraph;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.transformer.CompositeConverter;
import org.mule.transformer.TransformerWeighting;

public class GraphTransformerResolver
implements TransformerResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected TransformationGraph graph;
    private ReentrantReadWriteLock readWriteLock;
    private LRUMap lruMap;
    private Set<Transformer> registeredTransformers = new HashSet<Transformer>();

    public GraphTransformerResolver() {
        this.graph = new TransformationGraph();
        this.readWriteLock = new ReentrantReadWriteLock();
        this.lruMap = new LRUMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transformer resolve(DataType<?> source, DataType<?> result) throws ResolverException {
        this.readWriteLock.readLock().lock();
        String cacheKey = this.getDataTypeSourceResultPairHash(source, result);
        if (this.lruMap.containsKey((Object)cacheKey)) {
            return (Transformer)this.lruMap.get((Object)cacheKey);
        }
        try {
            Transformer nearestTransformerMatch = null;
            List<List<TransformationEdge>> transformationPaths = this.findTransformationPaths(source, result);
            if (transformationPaths.size() != 0) {
                this.sortTransformationPathsByLength(transformationPaths);
                List<Transformer> transformers = this.createTransformers(this.getShortestTransformationPaths(transformationPaths));
                nearestTransformerMatch = this.getNearestTransformerMatch(transformers, source.getType(), result.getType());
            }
            this.lruMap.put((Object)cacheKey, nearestTransformerMatch);
            Transformer transformer = nearestTransformerMatch;
            return transformer;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private List<List<TransformationEdge>> getShortestTransformationPaths(List<List<TransformationEdge>> transformationPaths) {
        int index;
        int shortestPathLength = transformationPaths.get(0).size();
        for (index = 1; index < transformationPaths.size() && transformationPaths.get(index).size() <= shortestPathLength; ++index) {
        }
        return transformationPaths.subList(0, index);
    }

    private void sortTransformationPathsByLength(List<List<TransformationEdge>> transformationPaths) {
        Collections.sort(transformationPaths, new Comparator<List<TransformationEdge>>(){

            @Override
            public int compare(List<TransformationEdge> transformationEdges, List<TransformationEdge> transformationEdges1) {
                return transformationEdges.size() - transformationEdges1.size();
            }
        });
    }

    public List<Transformer> lookupTransformers(DataType<?> source, DataType<?> target) {
        List<Transformer> transformers = new LinkedList<Transformer>();
        if (!this.graph.containsVertex(source)) {
            return transformers;
        }
        if (!this.graph.containsVertex(target)) {
            return transformers;
        }
        HashSet visited = new HashSet();
        List<List<TransformationEdge>> transformationPaths = this.findTransformationPaths(source, target, visited);
        transformers = this.createTransformers(transformationPaths);
        return transformers;
    }

    private List<Transformer> createTransformers(List<List<TransformationEdge>> transformationPaths) {
        LinkedList<Transformer> transformers = new LinkedList<Transformer>();
        for (List<TransformationEdge> transformationPath : transformationPaths) {
            Transformer[] pathTransformers = new Transformer[transformationPath.size()];
            int index = 0;
            for (TransformationEdge edge : transformationPath) {
                pathTransformers[index++] = edge.transformer;
            }
            Transformer transformer = transformationPath.size() == 1 ? transformationPath.get(0).getTransformer() : new CompositeConverter(pathTransformers);
            transformers.add(transformer);
        }
        return transformers;
    }

    private List<List<TransformationEdge>> findTransformationPaths(DataType<?> source, DataType<?> target) {
        List<List<TransformationEdge>> transformationPaths = new LinkedList<List<TransformationEdge>>();
        if (!this.graph.containsVertex(source)) {
            return transformationPaths;
        }
        if (!this.graph.containsVertex(target)) {
            return transformationPaths;
        }
        HashSet visited = new HashSet();
        transformationPaths = this.findTransformationPaths(source, target, visited);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("TransformationPaths: " + transformationPaths));
        }
        return transformationPaths;
    }

    private List<List<TransformationEdge>> findTransformationPaths(DataType<?> source, DataType<?> target, Set<DataType<?>> visited) {
        LinkedList<List<TransformationEdge>> transformers = new LinkedList<List<TransformationEdge>>();
        if (visited.contains(source)) {
            return transformers;
        }
        visited.add(source);
        Set transformationEdges = this.graph.outgoingEdgesOf(source);
        for (TransformationEdge transformationEdge : transformationEdges) {
            DataType edgeTarget = (DataType)this.graph.getEdgeTarget(transformationEdge);
            if (edgeTarget.equals(target)) {
                LinkedList<TransformationEdge> transformationEdges1 = new LinkedList<TransformationEdge>();
                transformationEdges1.add(transformationEdge);
                transformers.add(transformationEdges1);
                continue;
            }
            List<List<TransformationEdge>> newTransformations = this.findTransformationPaths(edgeTarget, target, visited);
            for (List<TransformationEdge> transformationEdgeList : newTransformations) {
                transformationEdgeList.add(0, transformationEdge);
                transformers.add(transformationEdgeList);
            }
        }
        visited.remove(source);
        return transformers;
    }

    protected Transformer getNearestTransformerMatch(List<Transformer> trans, Class input, Class output) throws ResolverException {
        if (trans.size() == 0) {
            return null;
        }
        if (trans.size() == 1) {
            return trans.get(0);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Comparing transformers for best match: input = " + input + " output = " + output + " Possible transformers = " + trans));
        }
        LinkedList<TransformerWeighting> weightings = new LinkedList<TransformerWeighting>();
        for (Transformer transformer : trans) {
            TransformerWeighting current = new TransformerWeighting(input, output, transformer);
            weightings.add(current);
        }
        Collections.sort(weightings);
        return ((TransformerWeighting)weightings.get(weightings.size() - 1)).getTransformer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transformerChange(Transformer transformer, TransformerResolver.RegistryAction registryAction) {
        if (!(transformer instanceof Converter)) {
            return;
        }
        try {
            this.readWriteLock.writeLock().lock();
            if (registryAction == TransformerResolver.RegistryAction.ADDED) {
                this.addTransformer(transformer);
            } else if (registryAction == TransformerResolver.RegistryAction.REMOVED) {
                this.removeTransformer(transformer);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private void removeTransformer(Transformer transformer) {
        if (!this.registeredTransformers.contains(transformer)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Attempt to remove an unregistered transformer: " + transformer));
            }
            return;
        }
        DataType<?> returnDataType = transformer.getReturnDataType();
        for (DataType<?> sourceDataType : transformer.getSourceDataTypes()) {
            Set allEdges = this.graph.getAllEdges(sourceDataType, returnDataType);
            for (TransformationEdge edge : allEdges) {
                if (edge.transformer != transformer) continue;
                DataType source = (DataType)this.graph.getEdgeSource(edge);
                DataType target = (DataType)this.graph.getEdgeTarget(edge);
                this.graph.removeEdge(edge);
                if (this.graph.inDegreeOf(source) == 0 && this.graph.outDegreeOf(source) == 0) {
                    this.graph.removeVertex(source);
                }
                if (this.graph.inDegreeOf(target) != 0 || this.graph.outDegreeOf(target) != 0) continue;
                this.graph.removeVertex(target);
            }
        }
        this.registeredTransformers.remove(transformer);
        this.lruMap.clear();
    }

    private void addTransformer(Transformer transformer) {
        if (this.registeredTransformers.contains(transformer)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Attempting to register an already registered transformer: " + transformer));
            }
            return;
        }
        DataType<?> returnDataType = transformer.getReturnDataType();
        if (!this.graph.containsVertex(returnDataType)) {
            this.graph.addVertex(returnDataType);
        }
        for (DataType<?> sourceDataType : transformer.getSourceDataTypes()) {
            if (!this.graph.containsVertex(sourceDataType)) {
                this.graph.addVertex(sourceDataType);
            }
            this.graph.addEdge(sourceDataType, returnDataType, new TransformationEdge(transformer));
        }
        this.registeredTransformers.add(transformer);
        this.lruMap.clear();
    }

    private String getDataTypeSourceResultPairHash(DataType<?> source, DataType<?> result) {
        StringBuilder builder = new StringBuilder();
        builder.append(source.getClass().getName());
        builder.append(source.hashCode());
        builder.append(":");
        builder.append(result.getClass().getName());
        builder.append(result.hashCode());
        return builder.toString();
    }

    protected class TransformationGraph
    extends DirectedMultigraph<DataType<?>, TransformationEdge> {
        public TransformationGraph() {
            super(TransformationEdge.class);
        }
    }

    protected class TransformationEdge {
        private final Transformer transformer;

        public TransformationEdge(Transformer transformer) {
            this.transformer = transformer;
        }

        public Transformer getTransformer() {
            return this.transformer;
        }

        public String toString() {
            return this.transformer.getClass().getName();
        }
    }
}

