/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.util.LinkedList;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;

public class CompositeConverter
implements Transformer,
Converter {
    private String name;
    protected LinkedList<Transformer> chain;

    public CompositeConverter(Transformer ... transformers) {
        if (transformers.length == 0) {
            throw new IllegalArgumentException("There must be at least one transformer");
        }
        this.chain = new LinkedList();
        for (Transformer transformer : transformers) {
            if (!(transformer instanceof Converter)) {
                throw new IllegalArgumentException("Transformer must implement Converter interface");
            }
            this.chain.addLast(transformer);
        }
    }

    @Override
    public boolean isSourceTypeSupported(Class<?> aClass) {
        return this.chain.size() > 0 && this.chain.peekFirst().isSourceTypeSupported(aClass);
    }

    @Override
    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return this.chain.size() > 0 && this.chain.peekFirst().isSourceDataTypeSupported(dataType);
    }

    @Override
    public List<Class<?>> getSourceTypes() {
        return this.chain.peekFirst().getSourceTypes();
    }

    @Override
    public List<DataType<?>> getSourceDataTypes() {
        return this.chain.peekFirst().getSourceDataTypes();
    }

    @Override
    public boolean isAcceptNull() {
        return this.chain.size() > 0 && this.chain.peekFirst().isAcceptNull();
    }

    @Override
    public boolean isIgnoreBadInput() {
        return this.chain.size() > 0 && this.chain.peekFirst().isIgnoreBadInput();
    }

    @Override
    public Object transform(Object src) throws TransformerException {
        return this.transform(src, null);
    }

    @Override
    public Object transform(Object src, String encoding) throws TransformerException {
        Object current = src;
        String currentEncoding = encoding;
        for (Transformer transformer : this.chain) {
            current = currentEncoding != null ? transformer.transform(current, currentEncoding) : transformer.transform(current);
            currentEncoding = transformer.getEncoding();
        }
        return current;
    }

    @Override
    public void setReturnClass(Class<?> theClass) {
        if (this.chain.size() > 0) {
            this.chain.peekLast().setReturnClass(theClass);
            return;
        }
        throw new IllegalStateException("Cannot set return class on an empty transformer chain");
    }

    @Override
    public Class<?> getReturnClass() {
        return this.chain.peekLast().getReturnClass();
    }

    @Override
    public void setReturnDataType(DataType<?> type) {
        this.chain.peekLast().setReturnDataType(type);
    }

    @Override
    public DataType<?> getReturnDataType() {
        return this.chain.peekLast().getReturnDataType();
    }

    @Override
    public String getMimeType() {
        return this.chain.peekLast().getMimeType();
    }

    @Override
    public String getEncoding() {
        return this.chain.peekLast().getEncoding();
    }

    @Override
    public ImmutableEndpoint getEndpoint() {
        return this.chain.peekFirst().getEndpoint();
    }

    @Override
    public void dispose() {
        for (Transformer transformer : this.chain) {
            transformer.dispose();
        }
    }

    @Override
    public void setEndpoint(ImmutableEndpoint ep) {
        for (Transformer transformer : this.chain) {
            transformer.setEndpoint(ep);
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        for (Transformer transformer : this.chain) {
            transformer.initialise();
        }
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (event != null && event.getMessage() != null) {
            try {
                event.getMessage().applyTransformers(event, this);
            }
            catch (Exception e) {
                throw new TransformerMessagingException(event, this, (Throwable)e);
            }
        }
        return event;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        for (Transformer transformer : this.chain) {
            transformer.setMuleContext(context);
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriorityWeighting() {
        int priorityWeighting = 0;
        for (Transformer transformer : this.chain) {
            if (!(transformer instanceof Converter)) continue;
            priorityWeighting += ((Converter)((Object)transformer)).getPriorityWeighting();
        }
        return priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int weighting) {
    }
}

