/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.chain;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.mule.MessageExchangePattern;
import org.mule.OptimizedRequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.component.Component;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.processor.RequestReplyReplierMessageProcessor;
import org.mule.api.transformer.Transformer;
import org.mule.construct.Flow;
import org.mule.processor.chain.AbstractMessageProcessorChain;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.MessageFilter;

public class DefaultMessageProcessorChain
extends AbstractMessageProcessorChain {
    protected DefaultMessageProcessorChain(List<MessageProcessor> processors) {
        super(null, processors);
    }

    protected DefaultMessageProcessorChain(MessageProcessor ... processors) {
        super(null, Arrays.asList(processors));
    }

    protected DefaultMessageProcessorChain(String name, List<MessageProcessor> processors) {
        super(name, processors);
    }

    protected DefaultMessageProcessorChain(String name, MessageProcessor ... processors) {
        super(name, Arrays.asList(processors));
    }

    public static MessageProcessorChain from(MessageProcessor messageProcessor) {
        return new DefaultMessageProcessorChain(messageProcessor);
    }

    public static MessageProcessorChain from(MessageProcessor ... messageProcessors) throws MuleException {
        return new DefaultMessageProcessorChainBuilder().chain(messageProcessors).build();
    }

    public static MessageProcessorChain from(List<MessageProcessor> messageProcessors) throws MuleException {
        return new DefaultMessageProcessorChainBuilder().chain(messageProcessors).build();
    }

    @Override
    protected MuleEvent doProcess(MuleEvent event) throws MuleException {
        FlowConstruct flowConstruct = event.getFlowConstruct();
        MuleEvent currentEvent = event;
        MuleEvent copy = null;
        Iterator processorIterator = this.processors.iterator();
        MessageProcessor processor = null;
        if (processorIterator.hasNext()) {
            processor = (MessageProcessor)processorIterator.next();
        }
        boolean resultWasNull = false;
        while (processor != null) {
            MuleEvent resultEvent;
            MessageProcessor nextProcessor = null;
            if (processorIterator.hasNext()) {
                nextProcessor = (MessageProcessor)processorIterator.next();
            }
            this.fireNotification(event.getFlowConstruct(), event, processor, 1601);
            if (flowConstruct instanceof Flow && nextProcessor != null && this.processorMayReturnNull(processor)) {
                copy = OptimizedRequestContext.criticalSetEvent(currentEvent);
            }
            try {
                resultEvent = processor.process(currentEvent);
            }
            catch (MessagingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessagingException(currentEvent, (Throwable)e);
            }
            if (resultWasNull && processor instanceof RequestReplyReplierMessageProcessor) {
                resultEvent = null;
            }
            this.fireNotification(event.getFlowConstruct(), resultEvent, processor, 1602);
            if (resultEvent != null) {
                resultWasNull = false;
                currentEvent = resultEvent;
            } else if (flowConstruct instanceof Flow && nextProcessor != null) {
                resultWasNull = true;
                currentEvent = copy != null ? copy : OptimizedRequestContext.criticalSetEvent(currentEvent);
            } else {
                return null;
            }
            processor = nextProcessor;
        }
        return currentEvent;
    }

    protected boolean processorMayReturnNull(MessageProcessor processor) {
        if (processor instanceof OutboundEndpoint) {
            MessageExchangePattern exchangePattern = ((OutboundEndpoint)processor).getExchangePattern();
            return exchangePattern == null ? true : !exchangePattern.hasResponse();
        }
        return !(processor instanceof Component) && !(processor instanceof Transformer) && !(processor instanceof MessageFilter);
    }
}

