/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.mule.api.ExceptionPayload;
import org.mule.api.MuleMessage;
import org.mule.config.ExceptionHelper;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.filters.RegExFilter;
import org.mule.util.ClassUtils;

public class ExceptionTypeFilter
extends PayloadTypeFilter {
    private String expression;

    public ExceptionTypeFilter() {
    }

    public ExceptionTypeFilter(String expectedType) {
        try {
            Class exceptionType = ClassUtils.loadClass(expectedType, ExceptionTypeFilter.class);
            this.setExpectedType(exceptionType);
        }
        catch (ClassNotFoundException e) {
            this.expression = expectedType;
        }
    }

    public ExceptionTypeFilter(Class expectedType) {
        super(expectedType);
    }

    @Override
    public boolean accept(MuleMessage message) {
        ExceptionPayload epl = message.getExceptionPayload();
        if (this.getExpectedType() == null && this.expression == null) {
            return epl != null;
        }
        if (epl != null) {
            Throwable wrappedException = ExceptionHelper.getNonMuleException(epl.getException());
            if (this.getExpectedType() != null) {
                return this.getExpectedType().isAssignableFrom(epl.getException().getClass()) || wrappedException != null && this.getExpectedType().isAssignableFrom(wrappedException.getClass());
            }
            if (this.expression.startsWith("=")) {
                String expectedType = this.expression.substring(1, this.expression.length());
                return epl.getException().getClass().getName().equals(expectedType) || wrappedException != null && wrappedException.getClass().getName().equals(expectedType);
            }
            RegExFilter regExFilter = new RegExFilter(this.expression);
            return regExFilter.accept(epl.getException().getClass().getName()) || wrappedException != null && regExFilter.accept(wrappedException.getClass().getName());
        }
        return false;
    }
}

