/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.DefaultMuleException;
import org.mule.util.ArrayUtils;
import org.mule.util.StringUtils;

public class SystemUtils
extends org.apache.commons.lang.SystemUtils {
    protected static final Log logger = LogFactory.getLog(SystemUtils.class);
    private static final String[] UNIX_ENV_PREFIXES = new String[]{"declare -", "typeset -"};
    private static Map environment = null;

    public static synchronized Map getenv() {
        if (environment == null) {
            try {
                if (IS_JAVA_1_4) {
                    environment = Collections.unmodifiableMap(SystemUtils.getenvJDK14());
                } else {
                    Class<System> target = System.class;
                    Method envMethod = target.getMethod("getenv", ArrayUtils.EMPTY_CLASS_ARRAY);
                    environment = Collections.unmodifiableMap((Map)envMethod.invoke(target, (Object[])null));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Could not access OS environment: ", (Throwable)ex);
                environment = Collections.EMPTY_MAP;
            }
        }
        return environment;
    }

    private static Map getenvJDK14() throws Exception {
        HashMap<String, String> env = new HashMap<String, String>();
        Process process = null;
        try {
            String line;
            String command;
            boolean isUnix = true;
            if (IS_OS_WINDOWS) {
                command = "cmd /c set";
                isUnix = false;
            } else {
                command = "env";
            }
            process = Runtime.getRuntime().exec(command);
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = br.readLine()) != null) {
                for (int prefix = 0; prefix < UNIX_ENV_PREFIXES.length; ++prefix) {
                    if (!line.startsWith(UNIX_ENV_PREFIXES[prefix])) continue;
                    line = line.substring(UNIX_ENV_PREFIXES[prefix].length());
                }
                int index = -1;
                index = line.indexOf(61);
                if (index > -1) {
                    String key = line.substring(0, index).trim();
                    String value = line.substring(index + 1).trim();
                    if (isUnix && value.length() > 1 && (value.startsWith("\"") || value.startsWith("'"))) {
                        value = value.substring(1, value.length() - 1);
                    }
                    env.put(key, value);
                    continue;
                }
                env.put(line, "");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return env;
    }

    public static String getenv(String name) {
        return (String)SystemUtils.getenv().get(name);
    }

    public static boolean isSunJDK() {
        return JAVA_VM_VENDOR.toUpperCase().indexOf("SUN") != -1;
    }

    public static boolean isAppleJDK() {
        return JAVA_VM_VENDOR.toUpperCase().indexOf("APPLE") != -1;
    }

    public static boolean isIbmJDK() {
        return JAVA_VM_VENDOR.toUpperCase().indexOf("IBM") != -1;
    }

    private static CommandLine parseCommandLine(String[] args, String[][] opts) throws DefaultMuleException {
        Options options = new Options();
        for (int i = 0; i < opts.length; ++i) {
            options.addOption(opts[i][0], opts[i][1].equals("true"), opts[i][2]);
        }
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(options, args, true);
            if (line == null) {
                throw new DefaultMuleException("Unknown error parsing the Mule command line");
            }
            return line;
        }
        catch (ParseException p) {
            throw new DefaultMuleException("Unable to parse the Mule command line because of: " + p.toString(), (Throwable)p);
        }
    }

    public static String getCommandLineOption(String option, String[] args, String[][] opts) throws DefaultMuleException {
        CommandLine line = SystemUtils.parseCommandLine(args, opts);
        return line.getOptionValue(option);
    }

    public static boolean hasCommandLineOption(String option, String[] args, String[][] opts) throws DefaultMuleException {
        CommandLine line = SystemUtils.parseCommandLine(args, opts);
        return line.hasOption(option);
    }

    public static Map<String, Object> getCommandLineOptions(String[] args, String[][] opts) throws DefaultMuleException {
        CommandLine line = SystemUtils.parseCommandLine(args, opts);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        Option[] options = line.getOptions();
        for (int i = 0; i < options.length; ++i) {
            Option option = options[i];
            ret.put(option.getOpt(), option.getValue("true"));
        }
        return ret;
    }

    public static Map<String, String> parsePropertyDefinitions(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        int tokenStart = 0;
        while (tokenStart < input.length() && (tokenStart = StringUtils.indexOf((String)input, (String)"-D", (int)tokenStart)) != -1) {
            int keyEnd;
            int keyStart;
            if (keyStart == input.length()) break;
            char cursor = input.charAt(keyStart);
            if (cursor == ' ') continue;
            if (cursor == '=') {
                if ((tokenStart = StringUtils.indexOf((String)input, (char)' ', (int)tokenStart)) == -1) break;
                continue;
            }
            for (keyEnd = keyStart = (tokenStart += 2); keyEnd < input.length(); ++keyEnd) {
                cursor = input.charAt(keyEnd);
                if (cursor == ' ') {
                    tokenStart = keyEnd;
                    break;
                }
                if (cursor == '=') break;
            }
            String key = StringUtils.substring((String)input, (int)keyStart, (int)keyEnd);
            int valueStart = keyEnd;
            int valueEnd = keyEnd;
            String value = "true";
            if (keyEnd < input.length() && cursor != ' ') {
                valueEnd = valueStart = keyEnd + 1;
                cursor = input.charAt(valueStart);
                valueEnd = cursor == '\"' ? StringUtils.indexOf((String)input, (char)'\"', (int)(++valueStart)) : StringUtils.indexOf((String)input, (char)' ', (int)valueStart);
                if (valueEnd == -1) {
                    valueEnd = input.length();
                }
                value = StringUtils.substring((String)input, (int)valueStart, (int)valueEnd);
            }
            result.put(key, value);
            tokenStart = valueEnd;
        }
        return result;
    }

    public static String legalizeFileName(String name) {
        if (!IS_OS_WINDOWS) {
            return name;
        }
        return name.replaceAll("[:\\\\]", "_");
    }
}

