/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.IOException;
import java.io.Reader;

public class ChainedReader
extends Reader {
    private final Reader first;
    private final Reader second;
    private boolean firstRead = false;

    public ChainedReader(Reader first, Reader second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public void close() throws IOException {
        this.first.close();
        this.second.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (!this.firstRead) {
            int i = this.first.read(cbuf, off, len);
            if (i < len) {
                this.firstRead = true;
                int x = this.second.read(cbuf, i, len - i);
                return x + i;
            }
            return i;
        }
        return this.second.read(cbuf, off, len);
    }

    @Override
    public int read() throws IOException {
        if (!this.firstRead) {
            int i = this.first.read();
            if (i == -1) {
                this.firstRead = true;
                return this.second.read();
            }
            return i;
        }
        return this.second.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        if (!this.firstRead) {
            int i = this.first.read(cbuf);
            if (i < cbuf.length) {
                this.firstRead = true;
                int x = this.second.read(cbuf, i, cbuf.length - i);
                return x + i;
            }
            return i;
        }
        return this.second.read(cbuf);
    }
}

