/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.resource.spi.work.Work;
import org.apache.commons.lang.SerializationException;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionCallback;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transport.SessionHandler;
import org.mule.session.LegacySessionHandler;
import org.mule.session.MuleSessionHandler;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.TransactionTemplate;
import org.mule.transaction.TransactionTemplateFactory;
import org.mule.transport.AbstractConnector;
import org.mule.transport.AbstractMessageReceiver;

public abstract class AbstractReceiverWorker
implements Work {
    protected List<Object> messages;
    protected InboundEndpoint endpoint;
    protected AbstractMessageReceiver receiver;
    protected OutputStream out;

    public AbstractReceiverWorker(List<Object> messages, AbstractMessageReceiver receiver) {
        this(messages, receiver, null);
    }

    public AbstractReceiverWorker(List<Object> messages, AbstractMessageReceiver receiver, OutputStream out) {
        this.messages = messages;
        this.receiver = receiver;
        this.endpoint = receiver.getEndpoint();
        this.out = out;
    }

    public final void run() {
        this.doRun();
        this.release();
    }

    protected void doRun() {
        try {
            this.processMessages();
        }
        catch (MessagingException e) {
        }
        catch (Exception e) {
            this.receiver.getConnector().getMuleContext().getExceptionListener().handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessages() throws Exception {
        TransactionTemplate tt = TransactionTemplateFactory.createNestedTransactionTemplate(this.endpoint.getTransactionConfig(), this.receiver.getConnector().getMuleContext());
        TransactionCallback<List<MuleEvent>> cb = new TransactionCallback<List<MuleEvent>>(){

            @Override
            public List<MuleEvent> doInTransaction() throws Exception {
                final Transaction tx = TransactionCoordination.getInstance().getTransaction();
                if (tx != null) {
                    AbstractReceiverWorker.this.bindTransaction(tx);
                }
                ArrayList<MuleEvent> results = new ArrayList<MuleEvent>(AbstractReceiverWorker.this.messages.size());
                for (final Object payload : AbstractReceiverWorker.this.messages) {
                    TransactionTemplate exceptionHandlingTransactionTemplate = TransactionTemplateFactory.createExceptionHandlingTransactionTemplate(AbstractReceiverWorker.this.endpoint.getMuleContext());
                    MuleEvent resultEvent = null;
                    try {
                        resultEvent = exceptionHandlingTransactionTemplate.execute(new TransactionCallback<MuleEvent>(){

                            @Override
                            public MuleEvent doInTransaction() throws Exception {
                                Object preProcessedPayload = AbstractReceiverWorker.this.preProcessMessage(payload);
                                if (preProcessedPayload != null) {
                                    MuleSession session;
                                    MuleMessage muleMessage = AbstractReceiverWorker.this.receiver.createMuleMessage(preProcessedPayload, AbstractReceiverWorker.this.endpoint.getEncoding());
                                    AbstractReceiverWorker.this.preRouteMuleMessage(muleMessage);
                                    SessionHandler handler = AbstractReceiverWorker.this.endpoint.getConnector() instanceof AbstractConnector ? ((AbstractConnector)AbstractReceiverWorker.this.endpoint.getConnector()).getSessionHandler() : new MuleSessionHandler();
                                    try {
                                        session = handler.retrieveSessionInfoFromMessage(muleMessage);
                                    }
                                    catch (SerializationException e) {
                                        session = new LegacySessionHandler().retrieveSessionInfoFromMessage(muleMessage);
                                    }
                                    MuleEvent resultEvent = session != null ? AbstractReceiverWorker.this.receiver.routeMessage(muleMessage, session, tx, AbstractReceiverWorker.this.out) : AbstractReceiverWorker.this.receiver.routeMessage(muleMessage, tx, AbstractReceiverWorker.this.out);
                                    return resultEvent;
                                }
                                return null;
                            }
                        });
                    }
                    catch (MessagingException e) {
                        if (e.getEvent().getMessage().getExceptionPayload() != null) {
                            throw e;
                        }
                        resultEvent = e.getEvent();
                    }
                    if (resultEvent == null) continue;
                    results.add(resultEvent);
                }
                return results;
            }
        };
        try {
            List<MuleEvent> results = tt.execute(cb);
            this.handleResults(this.handleEventResults(results));
        }
        finally {
            this.messages.clear();
        }
    }

    protected List handleEventResults(List<MuleEvent> messages) throws Exception {
        ArrayList<MuleMessage> payloads = new ArrayList<MuleMessage>(messages.size());
        for (MuleEvent muleEvent : messages) {
            MuleMessage payload;
            MuleMessage result = muleEvent == null ? null : muleEvent.getMessage();
            if (result == null || (payload = this.postProcessMessage(result)) == null) continue;
            payloads.add(payload);
        }
        return payloads;
    }

    protected void preRouteMuleMessage(MuleMessage message) throws Exception {
    }

    protected abstract void bindTransaction(Transaction var1) throws TransactionException;

    protected void handleResults(List messages) throws Exception {
    }

    protected Object preProcessMessage(Object message) throws Exception {
        return message;
    }

    protected MuleMessage postProcessMessage(MuleMessage message) throws Exception {
        return message;
    }

    public void release() {
    }
}

