/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mule.RequestContext;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.transformer.simple.SerializableToByteArray;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;

public class ObjectToByteArray
extends SerializableToByteArray {
    public ObjectToByteArray() {
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.create(OutputHandler.class));
        this.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doTransform(Object src, String outputEncoding) throws TransformerException {
        try {
            if (src instanceof String) {
                return src.toString().getBytes(outputEncoding);
            }
            if (src instanceof InputStream) {
                InputStream is = (InputStream)src;
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                try {
                    IOUtils.copyLarge((InputStream)is, (OutputStream)byteOut);
                }
                finally {
                    is.close();
                }
                return byteOut.toByteArray();
            }
            if (src instanceof OutputHandler) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                try {
                    ((OutputHandler)src).write(RequestContext.getEvent(), bytes);
                    return bytes.toByteArray();
                }
                catch (IOException e) {
                    throw new TransformerException(this, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
        return super.doTransform(src, outputEncoding);
    }
}

