/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import java.text.MessageFormat;
import javax.transaction.Synchronization;
import org.mule.api.MuleContext;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.AbstractTransaction;
import org.mule.transaction.XaTransaction;

public class ExternalXaTransaction
extends XaTransaction {
    public ExternalXaTransaction(MuleContext muleContext) {
        super(muleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBegin() throws TransactionException {
        if (this.txManager == null) {
            throw new IllegalStateException(CoreMessages.objectNotRegistered("javax.transaction.TransactionManager", "Transaction Manager").getMessage());
        }
        try {
            ExternalXaTransaction externalXaTransaction = this;
            synchronized (externalXaTransaction) {
                this.transaction = this.txManager.getTransaction();
                this.transaction.registerSynchronization((Synchronization)new ExternalTransaction(this.muleContext));
            }
        }
        catch (Exception e) {
            throw new TransactionException(CoreMessages.cannotStartTransaction("XA"), (Throwable)e);
        }
    }

    class ExternalTransaction
    extends AbstractTransaction
    implements Synchronization {
        ExternalTransaction(MuleContext muleContext) {
            super(muleContext);
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            boolean commit = status == 3;
            try {
                if (commit) {
                    this.commit();
                } else {
                    this.rollback();
                }
            }
            catch (TransactionException ex) {
                this.logger.warn((Object)MessageFormat.format("Exception while {0} an external transaction {1}", commit ? "committing" : "rolling back", this), (Throwable)ex);
            }
        }

        @Override
        protected void unbindTransaction() {
        }

        @Override
        protected void doCommit() {
            ExternalXaTransaction.this.delistResources();
            ExternalXaTransaction.this.closeResources();
            ExternalXaTransaction.this.transaction = null;
        }

        @Override
        protected void doRollback() {
            ExternalXaTransaction.this.closeResources();
            ExternalXaTransaction.this.transaction = null;
        }

        @Override
        protected void doBegin() {
        }

        @Override
        public boolean isRollbackOnly() throws TransactionException {
            return ExternalXaTransaction.this.isRollbackOnly();
        }

        @Override
        public int getStatus() throws TransactionException {
            return ExternalXaTransaction.this.getStatus();
        }

        @Override
        public Object getResource(Object key) {
            return ExternalXaTransaction.this.getResource(key);
        }

        @Override
        public boolean hasResource(Object key) {
            return ExternalXaTransaction.this.hasResource(key);
        }

        @Override
        public void bindResource(Object key, Object resource) throws TransactionException {
        }

        @Override
        public void setRollbackOnly() throws TransactionException {
        }
    }
}

