/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.processor;

import org.apache.commons.lang.BooleanUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.service.Service;
import org.mule.api.transport.ReplyToHandler;
import org.mule.processor.AbstractInterceptingMessageProcessor;

public class ServiceInternalMessageProcessor
extends AbstractInterceptingMessageProcessor {
    protected Service service;

    public ServiceInternalMessageProcessor(Service service) {
        this.service = service;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        try {
            MuleEvent resultEvent = this.service.getComponent().process(event);
            resultEvent = this.processNext(resultEvent);
            if (!event.getExchangePattern().hasResponse()) {
                Object replyTo = event.getReplyToDestination();
                ReplyToHandler replyToHandler = event.getReplyToHandler();
                if (resultEvent != null && replyTo != null) {
                    String replyToStop = (String)resultEvent.getMessage().getInvocationProperty("MULE_REPLYTO_STOP");
                    if (!event.getExchangePattern().hasResponse() || !BooleanUtils.toBoolean((String)replyToStop)) {
                        this.processReplyTo(event, resultEvent, replyToHandler, replyTo);
                    }
                }
            }
            return resultEvent;
        }
        catch (Exception e) {
            event.getSession().setValid(false);
            if (e instanceof MuleException) {
                throw (MuleException)e;
            }
            throw new MessagingException(event, (Throwable)e);
        }
    }

    protected void processReplyTo(MuleEvent event, MuleEvent result, ReplyToHandler replyToHandler, Object replyTo) throws MuleException {
        String requestor;
        if (result != null && replyToHandler != null && ((requestor = (String)result.getMessage().getOutboundProperty("MULE_REPLYTO_REQUESTOR")) != null && !requestor.equals(this.service.getName()) || requestor == null)) {
            replyToHandler.processReplyTo(event, result.getMessage(), replyTo);
        }
    }
}

