/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.RequestContext;
import org.mule.api.AnnotatedObject;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.component.Component;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.model.Model;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.routing.RouterStatisticsRecorder;
import org.mule.api.service.Service;
import org.mule.api.source.MessageSource;
import org.mule.api.transaction.TransactionCallback;
import org.mule.component.simple.PassThroughComponent;
import org.mule.config.i18n.CoreMessages;
import org.mule.lifecycle.EmptyLifecycleCallback;
import org.mule.lifecycle.processor.ProcessIfStartedWaitIfPausedMessageProcessor;
import org.mule.management.stats.RouterStatistics;
import org.mule.management.stats.ServiceStatistics;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.MuleMessageInfoMapping;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.service.Pausable;
import org.mule.service.Resumable;
import org.mule.service.ServiceAsyncReplyCompositeMessageSource;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.service.ServiceLifecycleManager;
import org.mule.service.processor.ServiceAsyncRequestReplyRequestor;
import org.mule.transaction.TransactionTemplate;
import org.mule.transaction.TransactionTemplateFactory;
import org.mule.util.ClassUtils;

public abstract class AbstractService
implements Service,
MessageProcessor,
AnnotatedObject {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected ServiceStatistics stats;
    protected Model model;
    protected MuleContext muleContext;
    protected ServiceLifecycleManager lifecycleManager;
    public static final String INITIAL_STATE_STOPPED = "stopped";
    public static final String INITIAL_STATE_STARTED = "started";
    public static final String INITIAL_STATE_PAUSED = "paused";
    protected MessagingExceptionHandler exceptionListener;
    protected String name;
    protected MessageProcessor outboundRouter = new DefaultOutboundRouterCollection();
    protected MessageSource messageSource = new ServiceCompositeMessageSource();
    protected ServiceAsyncReplyCompositeMessageSource asyncReplyMessageSource = new ServiceAsyncReplyCompositeMessageSource();
    protected MessageProcessorChain messageProcessorChain;
    protected MessageInfoMapping messageInfoMapping = new MuleMessageInfoMapping();
    private final Map<QName, Object> annotations = new ConcurrentHashMap<QName, Object>();
    protected String initialState = "started";
    protected Component component = new PassThroughComponent();

    public AbstractService(MuleContext muleContext) {
        this.muleContext = muleContext;
        ((MuleContextAware)((Object)this.component)).setMuleContext(muleContext);
        try {
            this.lifecycleManager = new ServiceLifecycleManager(this, muleContext);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(CoreMessages.failedToCreate("Service Lifecycle Manager"), (Throwable)e);
        }
    }

    @Override
    public final synchronized void initialise() throws InitialisationException {
        try {
            this.lifecycleManager.fireInitialisePhase(new LifecycleCallback<FlowConstruct>(){

                @Override
                public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                    if (AbstractService.this.outboundRouter instanceof MuleContextAware) {
                        ((MuleContextAware)((Object)AbstractService.this.outboundRouter)).setMuleContext(AbstractService.this.muleContext);
                    }
                    if (AbstractService.this.exceptionListener == null) {
                        AbstractService.this.exceptionListener = AbstractService.this.getModel().getExceptionListener();
                    }
                    AbstractService.this.injectFlowConstructMuleContext(AbstractService.this.messageSource);
                    AbstractService.this.injectFlowConstructMuleContext(AbstractService.this.asyncReplyMessageSource);
                    AbstractService.this.injectFlowConstructMuleContext(AbstractService.this.messageProcessorChain);
                    AbstractService.this.injectFlowConstructMuleContext(AbstractService.this.component);
                    AbstractService.this.injectFlowConstructMuleContext(AbstractService.this.exceptionListener);
                    AbstractService.this.doInitialise();
                }
            });
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public void start() throws MuleException {
        if (!this.isStopped() && this.initialState.equals(INITIAL_STATE_STOPPED)) {
            this.lifecycleManager.fireStartPhase((LifecycleCallback<FlowConstruct>)new EmptyLifecycleCallback<FlowConstruct>());
            this.lifecycleManager.fireStopPhase((LifecycleCallback<FlowConstruct>)new EmptyLifecycleCallback<FlowConstruct>());
            this.logger.info((Object)("Service " + this.name + " has not been started (initial state = 'stopped')"));
            return;
        }
        this.lifecycleManager.fireStartPhase(new LifecycleCallback<FlowConstruct>(){

            @Override
            public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                AbstractService.this.doStart();
            }
        });
        if (this.initialState.equals(INITIAL_STATE_PAUSED)) {
            this.pause();
            this.logger.info((Object)("Service " + this.name + " has been started and paused (initial state = 'paused')"));
        }
    }

    @Override
    public final void pause() throws MuleException {
        this.lifecycleManager.firePausePhase(new LifecycleCallback<FlowConstruct>(){

            @Override
            public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                AbstractService.this.doPause();
            }
        });
    }

    @Override
    public final void resume() throws MuleException {
        this.lifecycleManager.fireResumePhase(new LifecycleCallback<FlowConstruct>(){

            @Override
            public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                AbstractService.this.doResume();
            }
        });
    }

    @Override
    public void stop() throws MuleException {
        this.lifecycleManager.fireStopPhase(new LifecycleCallback<FlowConstruct>(){

            @Override
            public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                AbstractService.this.doStop();
            }
        });
    }

    @Override
    public final void dispose() {
        try {
            if (this.isStarted() || this.isPaused()) {
                this.stop();
            }
            this.lifecycleManager.fireDisposePhase(new LifecycleCallback<FlowConstruct>(){

                @Override
                public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                    AbstractService.this.doDispose();
                }
            });
        }
        catch (MuleException e) {
            this.logger.error((Object)("Failed to stop service: " + this.name), (Throwable)e);
        }
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.lifecycleManager.getState();
    }

    @Override
    public boolean isStarted() {
        return this.lifecycleManager.getState().isStarted();
    }

    @Override
    public boolean isPaused() {
        return this.lifecycleManager.getCurrentPhase().equals("pause");
    }

    @Override
    public boolean isStopped() {
        return this.lifecycleManager.getState().isStopped();
    }

    public boolean isStopping() {
        return this.lifecycleManager.getState().isStopping();
    }

    protected void doPause() throws MuleException {
    }

    protected void doResume() throws MuleException {
    }

    protected void doForceStop() throws MuleException {
    }

    protected void doStop() throws MuleException {
        this.stopIfStoppable(this.messageSource);
        this.asyncReplyMessageSource.stop();
        this.stopIfStoppable(this.messageProcessorChain);
        this.stopIfStoppable(this.component);
        this.stopIfStoppable(this.exceptionListener);
    }

    protected void doStart() throws MuleException {
        this.startIfStartable(this.exceptionListener);
        this.startIfStartable(this.component);
        this.startIfStartable(this.messageProcessorChain);
        this.startIfStartable(this.messageSource);
        if (this.asyncReplyMessageSource.getEndpoints().size() > 0) {
            this.asyncReplyMessageSource.start();
        }
    }

    protected void doDispose() {
        this.disposeIfDisposable(this.component);
        this.disposeIfDisposable(this.messageProcessorChain);
        this.disposeIfDisposable(this.messageSource);
        this.disposeIfDisposable(this.exceptionListener);
        this.muleContext.getStatistics().remove(this.stats);
    }

    protected void doInitialise() throws InitialisationException {
        this.stats = this.createStatistics();
        this.stats.setEnabled(this.muleContext.getStatistics().isEnabled());
        this.muleContext.getStatistics().add(this.stats);
        RouterStatistics routerStatistics = null;
        if (this.outboundRouter instanceof OutboundRouterCollection) {
            routerStatistics = ((OutboundRouterCollection)this.outboundRouter).getRouterStatistics();
        }
        if (routerStatistics == null) {
            routerStatistics = new RouterStatistics(2);
        }
        this.stats.setOutboundRouterStat(routerStatistics);
        if (this.outboundRouter != null && this.outboundRouter instanceof RouterStatisticsRecorder) {
            ((RouterStatisticsRecorder)((Object)this.outboundRouter)).setRouterStatistics(routerStatistics);
        }
        RouterStatistics inboundRouterStatistics = new RouterStatistics(1);
        this.stats.setInboundRouterStat(inboundRouterStatistics);
        if (this.messageSource instanceof RouterStatisticsRecorder) {
            ((RouterStatisticsRecorder)((Object)this.messageSource)).setRouterStatistics(inboundRouterStatistics);
        }
        this.stats.setComponentStat(this.component.getStatistics());
        try {
            this.buildServiceMessageProcessorChain();
            this.injectFlowConstructMuleContext(this.messageProcessorChain);
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        this.messageSource.setListener(new AbstractInterceptingMessageProcessor(){

            @Override
            public MuleEvent process(MuleEvent event) throws MuleException {
                return AbstractService.this.messageProcessorChain.process(event);
            }
        });
        this.initialiseIfInitialisable(this.exceptionListener);
        this.initialiseIfInitialisable(this.component);
        this.initialiseIfInitialisable(this.messageProcessorChain);
        this.initialiseIfInitialisable(this.messageSource);
        if (this.asyncReplyMessageSource.getEndpoints().size() > 0) {
            this.asyncReplyMessageSource.initialise();
        }
    }

    public void forceStop() throws MuleException {
        this.doForceStop();
        this.stop();
    }

    protected void buildServiceMessageProcessorChain() throws MuleException {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder(this);
        builder.setName("Service '" + this.name + "' Processor Chain");
        builder.chain(this.getServiceStartedAssertingMessageProcessor());
        this.addMessageProcessors(builder);
        this.messageProcessorChain = builder.build();
    }

    protected MessageProcessor getServiceStartedAssertingMessageProcessor() {
        return new ProcessIfStartedWaitIfPausedMessageProcessor(this, this.lifecycleManager.getState());
    }

    protected abstract void addMessageProcessors(MessageProcessorChainBuilder var1);

    protected ServiceStatistics createStatistics() {
        return new ServiceStatistics(this.name);
    }

    @Override
    public ServiceStatistics getStatistics() {
        return this.stats;
    }

    @Override
    @Deprecated
    public void dispatchEvent(MuleEvent event) throws MuleException {
        this.messageProcessorChain.process(event);
    }

    @Override
    @Deprecated
    public MuleEvent sendEvent(MuleEvent event) throws MuleException {
        return this.messageProcessorChain.process(event);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("%s{%s}", ClassUtils.getSimpleName(this.getClass()), this.getName());
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public void setModel(Model model) {
        this.model = model;
    }

    @Override
    public MessagingExceptionHandler getExceptionListener() {
        return this.exceptionListener;
    }

    @Override
    public void setExceptionListener(MessagingExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    @Override
    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    @Override
    public void setMessageSource(MessageSource inboundMessageSource) {
        this.messageSource = inboundMessageSource;
    }

    @Override
    public MessageProcessor getOutboundMessageProcessor() {
        return this.outboundRouter;
    }

    @Deprecated
    public void setMessageProcessor(MessageProcessor processor) {
        this.setOutboundMessageProcessor(processor);
    }

    @Override
    public void setOutboundMessageProcessor(MessageProcessor processor) {
        this.outboundRouter = processor;
    }

    @Override
    public ServiceAsyncReplyCompositeMessageSource getAsyncReplyMessageSource() {
        return this.asyncReplyMessageSource;
    }

    @Override
    public void setAsyncReplyMessageSource(ServiceAsyncReplyCompositeMessageSource asyncReplyMessageSource) {
        this.asyncReplyMessageSource = asyncReplyMessageSource;
    }

    @Override
    public String getInitialState() {
        return this.initialState;
    }

    @Override
    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public void setComponent(Component component) {
        this.component = component;
        this.component.setFlowConstruct(this);
        if (component instanceof MuleContextAware) {
            ((MuleContextAware)((Object)component)).setMuleContext(this.muleContext);
        }
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public MessageInfoMapping getMessageInfoMapping() {
        return this.messageInfoMapping;
    }

    public void setMessageInfoMapping(MessageInfoMapping messageInfoMapping) {
        this.messageInfoMapping = messageInfoMapping;
    }

    protected long getAsyncReplyTimeout() {
        if (this.asyncReplyMessageSource.getTimeout() != null) {
            return this.asyncReplyMessageSource.getTimeout();
        }
        return this.muleContext.getConfiguration().getDefaultResponseTimeout();
    }

    protected ServiceAsyncRequestReplyRequestor createAsyncReplyProcessor() {
        ServiceAsyncRequestReplyRequestor asyncReplyMessageProcessor = new ServiceAsyncRequestReplyRequestor();
        asyncReplyMessageProcessor.setTimeout(this.getAsyncReplyTimeout());
        asyncReplyMessageProcessor.setFailOnTimeout(this.asyncReplyMessageSource.isFailOnTimeout());
        asyncReplyMessageProcessor.setReplySource(this.asyncReplyMessageSource);
        return asyncReplyMessageProcessor;
    }

    @Override
    public MuleEvent process(final MuleEvent event) throws MuleException {
        final DefaultMuleEvent newEvent = new DefaultMuleEvent(event, this);
        RequestContext.setEvent(newEvent);
        try {
            TransactionTemplate exceptionHandlingTransactionTemplate = TransactionTemplateFactory.createExceptionHandlingTransactionTemplate(this.muleContext);
            MuleEvent muleEvent = exceptionHandlingTransactionTemplate.execute(new TransactionCallback<MuleEvent>(){

                @Override
                public MuleEvent doInTransaction() throws Exception {
                    MuleEvent result = AbstractService.this.messageProcessorChain.process(newEvent);
                    if (result != null) {
                        result.getMessage().release();
                        return new DefaultMuleEvent(result, event.getFlowConstruct());
                    }
                    return null;
                }
            });
            return muleEvent;
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.createStaticMessage("Flow execution exception"), (Throwable)e);
        }
        finally {
            RequestContext.setEvent(event);
            event.getMessage().release();
        }
    }

    public MessageProcessorChain getMessageProcessorChain() {
        return this.messageProcessorChain;
    }

    protected void injectFlowConstructMuleContext(Object candidate) {
        if (candidate instanceof FlowConstructAware) {
            ((FlowConstructAware)candidate).setFlowConstruct(this);
        }
        if (candidate instanceof MuleContextAware) {
            ((MuleContextAware)candidate).setMuleContext(this.muleContext);
        }
    }

    protected void initialiseIfInitialisable(Object candidate) throws InitialisationException {
        if (candidate instanceof Initialisable) {
            ((Initialisable)candidate).initialise();
        }
    }

    protected void startIfStartable(Object candidate) throws MuleException {
        if (candidate instanceof Startable) {
            ((Startable)candidate).start();
        }
    }

    protected void stopIfStoppable(Object candidate) throws MuleException {
        if (candidate instanceof Stoppable) {
            ((Stoppable)candidate).stop();
        }
    }

    protected void disposeIfDisposable(Object candidate) {
        if (candidate instanceof Disposable) {
            ((Disposable)candidate).dispose();
        }
    }

    protected void pauseIfPausable(Object candidate) throws MuleException {
        if (candidate instanceof Pausable) {
            ((Pausable)candidate).pause();
        }
    }

    protected void resumeIfResumable(Object candidate) throws MuleException {
        if (candidate instanceof Resumable) {
            ((Resumable)candidate).resume();
        }
    }

    @Override
    public final Object getAnnotation(QName name) {
        return this.annotations.get(name);
    }

    @Override
    public final Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    @Override
    public final synchronized void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations.clear();
        this.annotations.putAll(newAnnotations);
    }
}

