/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.config.i18n.CoreMessages;
import org.mule.expression.ExpressionConfig;
import org.mule.routing.outbound.AbstractRecipientList;
import org.mule.util.StringUtils;

public class ExpressionRecipientList
extends AbstractRecipientList {
    public static final String DEFAULT_SELECTOR_PROPERTY = "recipients";
    public static final String DEFAULT_SELECTOR_EVALUATOR = "header";
    public static final String DEFAULT_SELECTOR_EXPRESSION = "recipients";
    private ExpressionConfig expressionConfig = new ExpressionConfig("recipients", "header", null);

    protected List getRecipients(MuleEvent event) throws CouldNotRouteOutboundMessageException {
        String expr = this.getFullExpression();
        if (!this.muleContext.getExpressionManager().isValidExpression(expr)) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.expressionInvalidForProperty("expression", expr), event, null);
        }
        Object msgRecipients = this.muleContext.getExpressionManager().evaluate(expr, event.getMessage());
        if (msgRecipients == null) {
            throw new CouldNotRouteOutboundMessageException(CoreMessages.propertyIsNotSetOnEvent(this.getFullExpression()), event, null);
        }
        if (msgRecipients instanceof String) {
            return Arrays.asList(StringUtils.splitAndTrim(msgRecipients.toString(), " ,;:"));
        }
        if (msgRecipients instanceof List) {
            return new ArrayList((List)msgRecipients);
        }
        this.logger.error((Object)("Recipients on message are neither String nor List but: " + msgRecipients.getClass()));
        throw new CouldNotRouteOutboundMessageException(CoreMessages.propertyIsNotSupportedType(this.getFullExpression(), new Class[]{String.class, List.class}, msgRecipients.getClass()), event, null);
    }

    public String getFullExpression() {
        if (this.getEvaluator().equalsIgnoreCase("custom")) {
            this.setEvaluator(this.getCustomEvaluator());
        }
        return this.expressionConfig.getFullExpression(this.muleContext.getExpressionManager());
    }

    public String getExpression() {
        return this.expressionConfig.getExpression();
    }

    public void setExpression(String expression) {
        this.expressionConfig.setExpression(expression);
    }

    public String getCustomEvaluator() {
        return this.expressionConfig.getCustomEvaluator();
    }

    public void setCustomEvaluator(String customEvaluator) {
        this.expressionConfig.setCustomEvaluator(customEvaluator);
    }

    public String getEvaluator() {
        return this.expressionConfig.getEvaluator();
    }

    public void setEvaluator(String evaluator) {
        this.expressionConfig.setEvaluator(evaluator);
    }
}

