/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.MatchableMessageProcessor;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCatchAllStrategy;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.routing.RouterStatisticsRecorder;
import org.mule.api.routing.RoutingException;
import org.mule.api.routing.TransformingMatchable;
import org.mule.config.i18n.CoreMessages;
import org.mule.management.stats.RouterStatistics;
import org.mule.routing.AbstractCatchAllStrategy;
import org.mule.util.ObjectUtils;

public class DefaultOutboundRouterCollection
implements OutboundRouterCollection {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected List<MatchableMessageProcessor> routers = new CopyOnWriteArrayList<MatchableMessageProcessor>();
    protected boolean matchAll = false;
    private OutboundRouterCatchAllStrategy catchAllStrategy;
    protected RouterStatistics statistics = new RouterStatistics(2);
    protected MuleContext muleContext;

    @Override
    public MuleEvent process(MuleEvent event) throws MessagingException {
        MuleMessage message = event.getMessage();
        MuleSession session = event.getSession();
        boolean matchfound = false;
        Iterator<MatchableMessageProcessor> iterator = this.getRoutes().iterator();
        while (iterator.hasNext()) {
            MuleMessage outboundRouterMessage;
            OutboundRouter outboundRouter = (OutboundRouter)iterator.next();
            if (iterator.hasNext() && (this.isMatchAll() || outboundRouter instanceof TransformingMatchable && ((TransformingMatchable)((Object)outboundRouter)).isTransformBeforeMatch())) {
                if (((DefaultMuleMessage)message).isConsumable()) {
                    throw new MessagingException(CoreMessages.cannotCopyStreamPayload(message.getPayload().getClass().getName()), event);
                }
                outboundRouterMessage = new DefaultMuleMessage(message.getPayload(), message, this.muleContext);
            } else {
                outboundRouterMessage = message;
            }
            try {
                if (!outboundRouter.isMatch(outboundRouterMessage)) continue;
                matchfound = true;
                OutboundRouter router = outboundRouter;
                MuleEvent result = router.process(event);
                if (this.isMatchAll()) continue;
                return result;
            }
            catch (MessagingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RoutingException(event, outboundRouter, (Throwable)e);
            }
        }
        if (!matchfound && this.getCatchAllStrategy() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message did not match any routers on: " + event.getFlowConstruct().getName() + " invoking catch all strategy"));
            }
            return this.catchAll(event);
        }
        if (!matchfound) {
            this.logger.warn((Object)("Message did not match any routers on: " + event.getFlowConstruct().getName() + " and there is no catch all strategy configured on this router.  Disposing message " + message));
        }
        return event;
    }

    protected MuleEvent catchAll(MuleEvent event) throws RoutingException {
        if (this.getRouterStatistics().isEnabled()) {
            this.getRouterStatistics().incrementCaughtMessage();
        }
        return this.getCatchAllStrategy().process(event);
    }

    @Override
    public void initialise() throws InitialisationException {
        for (MatchableMessageProcessor router : this.routers) {
            if (!(router instanceof Initialisable)) continue;
            ((Initialisable)((Object)router)).initialise();
        }
    }

    @Override
    public void dispose() {
        for (MatchableMessageProcessor router : this.routers) {
            if (!(router instanceof Disposable)) continue;
            ((Disposable)((Object)router)).dispose();
        }
    }

    @Deprecated
    public void setMessageProcessors(List<MatchableMessageProcessor> routers) {
        for (MatchableMessageProcessor router : routers) {
            this.addRoute(router);
        }
    }

    @Override
    public void addRoute(MatchableMessageProcessor router) {
        if (router instanceof RouterStatisticsRecorder) {
            ((RouterStatisticsRecorder)((Object)router)).setRouterStatistics(this.getRouterStatistics());
        }
        this.routers.add(router);
    }

    @Override
    public void removeRoute(MatchableMessageProcessor router) {
        this.routers.remove(router);
    }

    @Override
    public List<MatchableMessageProcessor> getRoutes() {
        return this.routers;
    }

    @Override
    public OutboundRouterCatchAllStrategy getCatchAllStrategy() {
        return this.catchAllStrategy;
    }

    @Override
    public void setCatchAllStrategy(OutboundRouterCatchAllStrategy catchAllStrategy) {
        this.catchAllStrategy = catchAllStrategy;
        if (this.catchAllStrategy != null && catchAllStrategy instanceof AbstractCatchAllStrategy) {
            ((AbstractCatchAllStrategy)this.catchAllStrategy).setRouterStatistics(this.statistics);
        }
    }

    @Override
    public boolean isMatchAll() {
        return this.matchAll;
    }

    @Override
    public void setMatchAll(boolean matchAll) {
        this.matchAll = matchAll;
    }

    @Override
    public RouterStatistics getRouterStatistics() {
        return this.statistics;
    }

    @Override
    public void setRouterStatistics(RouterStatistics stat) {
        this.statistics = stat;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public boolean hasEndpoints() {
        for (OutboundRouter outboundRouter : this.routers) {
            if (outboundRouter.getRoutes().size() <= 0 && !outboundRouter.isDynamicRoutes()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return ObjectUtils.toString(this);
    }
}

