/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.mule.DefaultMessageCollection;
import org.mule.DefaultMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.session.DefaultMuleSession;
import org.mule.util.ClassUtils;
import org.mule.util.store.DeserializationPostInitialisable;

public class EventGroup
implements Comparable<EventGroup>,
Serializable,
DeserializationPostInitialisable {
    private static final long serialVersionUID = 953739659615692697L;
    public static final MuleEvent[] EMPTY_EVENTS_ARRAY = new MuleEvent[0];
    private transient ObjectStoreManager objectStoreManager = null;
    private final Object groupId;
    transient ListableObjectStore<MuleEvent> events;
    private final long created = System.nanoTime();
    private final int expectedSize;
    private transient MuleContext muleContext;
    private final String storePrefix;
    private String commonRootId = null;
    private static boolean hasNoCommonRootId = false;
    public static final String DEFAULT_STORE_PREFIX = "DEFAULT_STORE";

    public EventGroup(Object groupId, MuleContext muleContext) {
        this(groupId, muleContext, -1, false, DEFAULT_STORE_PREFIX);
    }

    public EventGroup(Object groupId, MuleContext muleContext, int expectedSize, boolean storeIsPersistent, String storePrefix) {
        this.muleContext = muleContext;
        this.storePrefix = storePrefix;
        String storeKey = storePrefix + ".eventGroup." + groupId;
        this.events = (ListableObjectStore)this.getObjectStoreManager().getObjectStore(storeKey, storeIsPersistent);
        this.expectedSize = expectedSize;
        this.groupId = groupId;
    }

    @Override
    public int compareTo(EventGroup other) {
        Object otherId = other.getGroupId();
        if (this.groupId instanceof Comparable && otherId instanceof Comparable) {
            return ((Comparable)this.groupId).compareTo(otherId);
        }
        long diff = this.created - other.getCreated();
        return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventGroup)) {
            return false;
        }
        EventGroup other = (EventGroup)obj;
        if (this.groupId == null) {
            return other.groupId == null;
        }
        return this.groupId.equals(other.groupId);
    }

    public int hashCode() {
        return this.groupId.hashCode();
    }

    public Object getGroupId() {
        return this.groupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<MuleEvent> iterator() throws ObjectStoreException {
        ListableObjectStore<MuleEvent> listableObjectStore = this.events;
        synchronized (listableObjectStore) {
            if (this.events.allKeys().isEmpty()) {
                return IteratorUtils.emptyIterator();
            }
            return IteratorUtils.arrayIterator((Object[])this.toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleEvent[] toArray() throws ObjectStoreException {
        ListableObjectStore<MuleEvent> listableObjectStore = this.events;
        synchronized (listableObjectStore) {
            if (this.events.allKeys().isEmpty()) {
                return EMPTY_EVENTS_ARRAY;
            }
            List<Serializable> keys = this.events.allKeys();
            MuleEvent[] eventArray = new MuleEvent[keys.size()];
            for (int i = 0; i < keys.size(); ++i) {
                eventArray[i] = (MuleEvent)this.events.retrieve(keys.get(i));
            }
            return eventArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(MuleEvent event) throws ObjectStoreException {
        ListableObjectStore<MuleEvent> listableObjectStore = this.events;
        synchronized (listableObjectStore) {
            String key = event.getId() + event.getMessage().getCorrelationSequence();
            this.events.store((Serializable)((Object)key), event);
            if (!hasNoCommonRootId) {
                String rootId = event.getMessage().getMessageRootId();
                if (this.commonRootId == null) {
                    this.commonRootId = rootId;
                } else if (!this.commonRootId.equals(rootId)) {
                    hasNoCommonRootId = true;
                    this.commonRootId = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEvent(MuleEvent event) throws ObjectStoreException {
        ListableObjectStore<MuleEvent> listableObjectStore = this.events;
        synchronized (listableObjectStore) {
            this.events.remove((Serializable)((Object)event.getId()));
        }
    }

    public long getCreated() {
        return this.created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ListableObjectStore<MuleEvent> listableObjectStore = this.events;
        synchronized (listableObjectStore) {
            try {
                return this.events.allKeys().size();
            }
            catch (ObjectStoreException e) {
                return -1;
            }
        }
    }

    public int expectedSize() {
        return this.expectedSize;
    }

    public void clear() throws ObjectStoreException {
        this.getObjectStoreManager().disposeStore(this.events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer(80);
        buf.append(ClassUtils.getSimpleName(this.getClass()));
        buf.append(" {");
        buf.append("id=").append(this.groupId);
        buf.append(", expected size=").append(this.expectedSize);
        try {
            ListableObjectStore<MuleEvent> listableObjectStore = this.events;
            synchronized (listableObjectStore) {
                int currentSize = this.events.allKeys().size();
                buf.append(", current events=").append(currentSize);
                if (currentSize > 0) {
                    buf.append(" [");
                    Iterator<Serializable> i = this.events.allKeys().iterator();
                    while (i.hasNext()) {
                        Serializable id = i.next();
                        buf.append(((MuleEvent)this.events.retrieve(id)).getMessage().getUniqueId());
                        if (!i.hasNext()) continue;
                        buf.append(", ");
                    }
                    buf.append(']');
                }
            }
        }
        catch (ObjectStoreException e) {
            buf.append("ObjectStoreException " + e + " caught:" + e.getMessage());
        }
        buf.append('}');
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleMessageCollection toMessageCollection() throws ObjectStoreException {
        DefaultMessageCollection col;
        ListableObjectStore<MuleEvent> listableObjectStore = this.events;
        synchronized (listableObjectStore) {
            if (this.events.allKeys().isEmpty()) {
                DefaultMessageCollection defaultMessageCollection = new DefaultMessageCollection(null);
            }
            col = new DefaultMessageCollection(this.muleContext);
            for (Serializable id : this.events.allKeys()) {
                col.addMessage(((MuleEvent)this.events.retrieve(id)).getMessage());
            }
        }
        return col;
    }

    public String getCommonRootId() {
        return this.commonRootId;
    }

    public MuleEvent getMessageCollectionEvent() {
        try {
            if (this.size() > 0) {
                DefaultMuleEvent muleEvent = new DefaultMuleEvent((MuleMessage)this.toMessageCollection(), (MuleEvent)this.events.retrieve(this.events.allKeys().get(0)), this.getMergedSession());
                if (this.getCommonRootId() != null) {
                    muleEvent.getMessage().setMessageRootId(this.commonRootId);
                }
                return muleEvent;
            }
            return null;
        }
        catch (ObjectStoreException e) {
            return null;
        }
    }

    protected MuleSession getMergedSession() throws ObjectStoreException {
        DefaultMuleSession session = new DefaultMuleSession(((MuleEvent)this.events.retrieve(this.events.allKeys().get(0))).getSession());
        for (int i = 1; i < this.events.allKeys().size(); ++i) {
            session.getProperties().putAll(((MuleEvent)this.events.retrieve(this.events.allKeys().get(i))).getSession().getProperties());
        }
        return session;
    }

    private ObjectStoreManager getObjectStoreManager() {
        if (this.objectStoreManager == null) {
            this.objectStoreManager = (ObjectStoreManager)this.muleContext.getRegistry().get("_muleObjectStoreManager");
        }
        return this.objectStoreManager;
    }

    public void initAfterDeserialisation(MuleContext context) throws MuleException {
        this.muleContext = context;
        String storeKey = this.storePrefix + ".eventGroup." + this.groupId;
        this.events = (ListableObjectStore)this.getObjectStoreManager().getObjectStore(storeKey, true);
    }
}

