/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionEnricher;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.expression.InvalidExpressionException;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.lifecycle.Disposable;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.TemplateParser;

public class DefaultExpressionManager
implements ExpressionManager,
MuleContextAware {
    protected static final transient Log logger = LogFactory.getLog(DefaultExpressionManager.class);
    private TemplateParser parser = TemplateParser.createMuleStyleParser();
    private ConcurrentMap evaluators = new ConcurrentHashMap(8);
    private ConcurrentMap enrichers = new ConcurrentHashMap(8);
    private MuleContext muleContext;

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void registerEvaluator(ExpressionEvaluator evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("evaluator").getMessage());
        }
        String name = evaluator.getName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Evaluators already contain an object named '" + name + "'.  The previous object will be overwritten."));
        }
        this.evaluators.put(evaluator.getName(), evaluator);
    }

    @Override
    public void registerEnricher(ExpressionEnricher enricher) {
        if (enricher == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("enricher").getMessage());
        }
        String name = enricher.getName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Enrichers already contain an object named '" + name + "'.  The previous object will be overwritten."));
        }
        this.enrichers.put(enricher.getName(), enricher);
    }

    @Override
    public boolean isEvaluatorRegistered(String name) {
        return this.evaluators.containsKey(name);
    }

    @Override
    public boolean isEnricherRegistered(String name) {
        return this.enrichers.containsKey(name);
    }

    @Override
    public ExpressionEvaluator unregisterEvaluator(String name) {
        if (name == null) {
            return null;
        }
        ExpressionEvaluator evaluator = (ExpressionEvaluator)this.evaluators.remove(name);
        if (evaluator instanceof Disposable) {
            ((Disposable)((Object)evaluator)).dispose();
        }
        return evaluator;
    }

    @Override
    public ExpressionEnricher unregisterEnricher(String name) {
        if (name == null) {
            return null;
        }
        ExpressionEnricher enricher = (ExpressionEnricher)this.enrichers.remove(name);
        if (enricher instanceof Disposable) {
            ((Disposable)((Object)enricher)).dispose();
        }
        return enricher;
    }

    @Override
    public Object evaluate(String expression, MuleMessage message) throws ExpressionRuntimeException {
        return this.evaluate(expression, message, false);
    }

    @Override
    public Object evaluate(String expression, MuleMessage message, boolean failIfNull) throws ExpressionRuntimeException {
        String name;
        int i;
        if (expression == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("expression").getMessage());
        }
        if (expression.startsWith("#[")) {
            expression = expression.substring(2, expression.length() - 1);
        }
        if ((i = expression.indexOf(":")) > -1) {
            name = expression.substring(0, i);
            expression = expression.substring(i + "]".length());
        } else {
            name = expression;
            expression = null;
        }
        return this.evaluate(expression, name, message, failIfNull);
    }

    @Override
    public void enrich(String expression, MuleMessage message, Object object) throws ExpressionRuntimeException {
        String enricherName;
        int i;
        if (expression == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("expression").getMessage());
        }
        if (expression.startsWith("#[")) {
            expression = expression.substring(2, expression.length() - 1);
        }
        if ((i = expression.indexOf(":")) > -1) {
            enricherName = expression.substring(0, i);
            expression = expression.substring(i + "]".length());
        } else {
            enricherName = expression;
            expression = null;
        }
        this.enrich(expression, enricherName, message, object);
    }

    @Override
    public void enrich(String expression, String enricherName, MuleMessage message, Object object) {
        ExpressionEnricher enricher = (ExpressionEnricher)this.enrichers.get(enricherName);
        if (enricher == null) {
            throw new IllegalArgumentException(CoreMessages.expressionEnricherNotRegistered(enricherName).getMessage());
        }
        enricher.enrich(expression, message, object);
    }

    @Override
    public Object evaluate(String expression, String evaluator, MuleMessage message, boolean failIfNull) throws ExpressionRuntimeException {
        ExpressionEvaluator extractor = (ExpressionEvaluator)this.evaluators.get(evaluator);
        if (extractor == null) {
            throw new IllegalArgumentException(CoreMessages.expressionEvaluatorNotRegistered(evaluator).getMessage());
        }
        Object result = extractor.evaluate(expression, message);
        if (failIfNull && result == null) {
            throw new RequiredValueException(CoreMessages.expressionEvaluatorReturnedNull(evaluator, expression));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("Result of expression: {0}:{1} is: {2}", evaluator, expression, result));
        }
        return result;
    }

    @Override
    public boolean evaluateBoolean(String expression, String evaluator, MuleMessage message) throws ExpressionRuntimeException {
        return this.evaluateBoolean(expression, evaluator, message, false, false);
    }

    @Override
    public boolean evaluateBoolean(String expression, MuleMessage message) throws ExpressionRuntimeException {
        return this.evaluateBoolean(expression, message, false, false);
    }

    @Override
    public boolean evaluateBoolean(String expression, String evaluator, MuleMessage message, boolean nullReturnsTrue, boolean nonBooleanReturnsTrue) throws ExpressionRuntimeException {
        try {
            return this.resolveBoolean(this.evaluate(expression, evaluator, message, false), nullReturnsTrue, nonBooleanReturnsTrue, expression);
        }
        catch (RequiredValueException e) {
            return nullReturnsTrue;
        }
    }

    @Override
    public boolean evaluateBoolean(String expression, MuleMessage message, boolean nullReturnsTrue, boolean nonBooleanReturnsTrue) throws ExpressionRuntimeException {
        try {
            return this.resolveBoolean(this.evaluate(expression, message, false), nullReturnsTrue, nonBooleanReturnsTrue, expression);
        }
        catch (RequiredValueException e) {
            return nullReturnsTrue;
        }
    }

    protected boolean resolveBoolean(Object result, boolean nullReturnsTrue, boolean nonBooleanReturnsTrue, String expression) {
        if (result == null) {
            return nullReturnsTrue;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof String) {
            if (result.toString().toLowerCase().equalsIgnoreCase("false")) {
                return false;
            }
            if (result.toString().toLowerCase().equalsIgnoreCase("true")) {
                return true;
            }
            return nonBooleanReturnsTrue;
        }
        logger.warn((Object)("Expression: " + expression + ", returned an non-boolean result. Returning: " + nonBooleanReturnsTrue));
        return nonBooleanReturnsTrue;
    }

    @Override
    public String parse(String expression, MuleMessage message) throws ExpressionRuntimeException {
        return this.parse(expression, message, false);
    }

    @Override
    public String parse(String expression, final MuleMessage message, final boolean failIfNull) throws ExpressionRuntimeException {
        return this.parser.parse(new TemplateParser.TemplateCallback(){

            @Override
            public Object match(String token) {
                Object result = DefaultExpressionManager.this.evaluate(token, message, failIfNull);
                if (result instanceof MuleMessage) {
                    return ((MuleMessage)result).getPayload();
                }
                return result;
            }
        }, expression);
    }

    @Override
    public synchronized void clearEvaluators() {
        for (ExpressionEvaluator evaluator : this.evaluators.values()) {
            if (!(evaluator instanceof Disposable)) continue;
            ((Disposable)((Object)evaluator)).dispose();
        }
        this.evaluators.clear();
    }

    @Override
    public void clearEnrichers() {
        for (ExpressionEnricher enricher : this.enrichers.values()) {
            if (!(enricher instanceof Disposable)) continue;
            ((Disposable)((Object)enricher)).dispose();
        }
        this.enrichers.clear();
    }

    @Override
    public boolean isExpression(String string) {
        return string.contains("#[");
    }

    @Override
    public boolean isValidExpression(String expression) {
        try {
            this.validateExpression(expression);
            return true;
        }
        catch (InvalidExpressionException e) {
            logger.warn((Object)e.getMessage());
            return false;
        }
    }

    @Override
    public void validateExpression(String expression) throws InvalidExpressionException {
        if (!this.muleContext.getConfiguration().isValidateExpressions()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Validate expressions is turned off, no checking done for: " + expression));
            }
            return;
        }
        try {
            this.parser.validate(expression);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidExpressionException(expression, e.getMessage());
        }
        final AtomicBoolean valid = new AtomicBoolean(true);
        final AtomicBoolean match = new AtomicBoolean(false);
        final StringBuffer message = new StringBuffer();
        this.parser.parse(new TemplateParser.TemplateCallback(){

            @Override
            public Object match(String token) {
                match.set(true);
                if (token.indexOf(":") == -1) {
                    if (valid.get()) {
                        valid.compareAndSet(true, false);
                    }
                    message.append(token).append(" is invalid\n");
                }
                return null;
            }
        }, expression);
        if (message.length() > 0) {
            throw new InvalidExpressionException(expression, message.toString());
        }
        if (!match.get()) {
            throw new InvalidExpressionException(expression, "Expression string is not an expression.  Use isExpression(String) to validate first");
        }
    }
}

