/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.exception.RollbackSourceCallback;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.exception.AbstractExceptionStrategy;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.message.DefaultExceptionPayload;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.requestreply.ReplyToPropertyRequestReplyReplier;

public abstract class TemplateMessagingExceptionStrategy
extends AbstractExceptionStrategy
implements MessagingExceptionHandler {
    private MessageProcessorChain configuredMessageProcessors;
    private MessageProcessor replyToMessageProcessor = new ReplyToPropertyRequestReplyReplier();

    public TemplateMessagingExceptionStrategy(MuleContext muleContext) {
        super(muleContext);
    }

    @Override
    public final MuleEvent handleException(Exception exception, MuleEvent event, RollbackSourceCallback rollbackMethod) {
        this.fireNotification(exception);
        this.logException(exception);
        this.processStatistics(event);
        event = this.beforeRouting(exception, event);
        event = this.route(event, exception);
        this.processOutboundRouterStatistics(event);
        event = this.afterRouting(exception, event);
        this.processReplyTo(event);
        this.closeStream(event.getMessage());
        this.manageTransaction();
        this.nullifyExceptionPayloadIfRequired(event);
        return event;
    }

    protected void processReplyTo(MuleEvent event) {
        try {
            this.replyToMessageProcessor.process(event);
        }
        catch (MuleException e) {
            this.logFatal(event, e);
        }
    }

    protected abstract void nullifyExceptionPayloadIfRequired(MuleEvent var1);

    protected void manageTransaction() {
        this.resolveTransactionIfAny();
        this.resumeSuspendedTransactionIfAny();
    }

    private void processStatistics(MuleEvent event) {
        FlowConstructStatistics statistics = event.getFlowConstruct().getStatistics();
        if (statistics != null && statistics.isEnabled()) {
            statistics.incExecutionError();
        }
    }

    @Override
    public final MuleEvent handleException(Exception exception, MuleEvent event) {
        return this.handleException(exception, event, null);
    }

    protected MuleEvent route(MuleEvent event, Throwable t) {
        if (!this.getMessageProcessors().isEmpty()) {
            try {
                event.getMessage().setExceptionPayload(new DefaultExceptionPayload(t));
                MuleEvent result = this.configuredMessageProcessors.process(event);
                this.processOutboundRouterStatistics(event);
                return result;
            }
            catch (Exception e) {
                this.logFatal(event, e);
            }
        }
        return event;
    }

    @Override
    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        super.doInitialise(muleContext);
        DefaultMessageProcessorChainBuilder defaultMessageProcessorChainBuilder = new DefaultMessageProcessorChainBuilder(this.flowConstruct);
        try {
            this.configuredMessageProcessors = defaultMessageProcessorChainBuilder.chain(this.getMessageProcessors()).build();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected abstract MuleEvent afterRouting(Exception var1, MuleEvent var2);

    protected abstract MuleEvent beforeRouting(Exception var1, MuleEvent var2);
}

