/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.io.Serializable;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.store.ListableObjectStore;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueManager;

public class QueueProfile {
    private int maxOutstandingMessages = 0;
    private ListableObjectStore<Serializable> objectStore;

    public static QueueProfile newInstancePersistingToDefaultMemoryQueueStore(MuleContext muleContext) {
        ListableObjectStore defaultMemoryObjectStore = (ListableObjectStore)muleContext.getRegistry().lookupObject("_defaultInMemoryQueueStore");
        return new QueueProfile(defaultMemoryObjectStore);
    }

    public QueueProfile(ListableObjectStore<Serializable> objectStore) {
        this.objectStore = objectStore;
    }

    public QueueProfile(QueueProfile queueProfile) {
        this.maxOutstandingMessages = queueProfile.getMaxOutstandingMessages();
        this.objectStore = queueProfile.objectStore;
    }

    public QueueProfile(int maxOutstandingMessages, ListableObjectStore<Serializable> objectStore) {
        this.maxOutstandingMessages = maxOutstandingMessages;
        this.objectStore = objectStore;
    }

    public int getMaxOutstandingMessages() {
        return this.maxOutstandingMessages;
    }

    public void setMaxOutstandingMessages(int maxOutstandingMessages) {
        this.maxOutstandingMessages = maxOutstandingMessages;
    }

    public QueueConfiguration configureQueue(MuleContext context, String component, QueueManager queueManager) throws InitialisationException {
        if (this.objectStore instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.objectStore)).setMuleContext(context);
        }
        QueueConfiguration qc = new QueueConfiguration(context, this.maxOutstandingMessages, this.objectStore);
        queueManager.setQueueConfiguration(component, qc);
        return qc;
    }

    public ListableObjectStore<Serializable> getObjectStore() {
        return this.objectStore;
    }

    public void setQueueStore(ListableObjectStore<Serializable> objectStore) {
        this.objectStore = objectStore;
    }

    public void addQueueStore(ListableObjectStore<Serializable> objectStore) {
        this.objectStore = objectStore;
    }

    public String toString() {
        return "QueueProfile{maxOutstandingMessage=" + this.maxOutstandingMessages + ", storeType=" + this.objectStore.getClass() + "}";
    }
}

