/*
 * Decompiled with CFR 0.152.
 */
package org.mule.cache.keygenerator;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.security.MessageDigest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.cache.keygenerator.KeyGenerator;

public class MD5KeyGenerator
implements KeyGenerator {
    protected Log logger = LogFactory.getLog(this.getClass());

    @Override
    public Serializable generateKey(MuleEvent event) throws NotSerializableException {
        try {
            byte[] bytesOfMessage = event.getMessageAsBytes();
            MessageDigest md = MessageDigest.getInstance("MD5");
            String key = new String(md.digest(bytesOfMessage));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Generated key for event: " + event + " key: " + key));
            }
            return key;
        }
        catch (Exception e) {
            NotSerializableException notSerializableException = new NotSerializableException(e.getMessage());
            notSerializableException.initCause(e);
            throw notSerializableException;
        }
    }
}

