/*
 * Decompiled with CFR 0.152.
 */
package org.mule.cache.keygenerator;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.cache.keygenerator.KeyGenerator;

public class ExpressionKeyGenerator
implements KeyGenerator {
    protected Log logger = LogFactory.getLog(this.getClass());
    private String expression;

    @Override
    public Serializable generateKey(MuleEvent event) throws NotSerializableException {
        Object key = event.getMuleContext().getExpressionManager().evaluate(this.expression, event.getMessage());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Generated key for event: " + event + " key: " + key));
        }
        if (key instanceof Serializable) {
            return (Serializable)key;
        }
        throw new NotSerializableException("Generated key must a serializable object but was " + (key != null ? key.getClass().getName() : "null"));
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }
}

