/*
 * Decompiled with CFR 0.152.
 */
package org.mule.cache;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.cache.CachingStrategy;
import org.mule.cache.ObjectStoreCachingStrategy;
import org.mule.processor.AbstractMessageProcessorOwner;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.filters.AcceptAllFilter;

public class CachingMessageProcessor
extends AbstractMessageProcessorOwner
implements Initialisable,
InterceptingMessageProcessor {
    protected Log logger = LogFactory.getLog(this.getClass());
    private List<MessageProcessor> messageProcessors;
    private MessageProcessor cachedMessageProcessor;
    private MessageProcessor next;
    private CachingStrategy cachingStrategy;
    private Filter filter;

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.cachingStrategy == null) {
            this.cachingStrategy = this.createDefaultCachingStrategy();
        }
        if (this.filter == null) {
            this.filter = this.createDefaultCacheFilter();
        }
    }

    protected AcceptAllFilter createDefaultCacheFilter() {
        return new AcceptAllFilter();
    }

    protected CachingStrategy createDefaultCachingStrategy() {
        return new ObjectStoreCachingStrategy();
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleEvent responseFromCachedMessageProcessor = this.filter.accept(event.getMessage()) ? this.cachingStrategy.process(event, this.cachedMessageProcessor) : this.cachedMessageProcessor.process(event);
        return this.processNext(responseFromCachedMessageProcessor);
    }

    protected MuleEvent processNext(MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        return this.next.process(event);
    }

    public void setMessageProcessors(List<MessageProcessor> messageProcessors) throws MuleException {
        this.messageProcessors = messageProcessors;
        this.cachedMessageProcessor = new DefaultMessageProcessorChainBuilder().chain(messageProcessors).build();
    }

    @Override
    protected List<MessageProcessor> getOwnedMessageProcessors() {
        return this.messageProcessors;
    }

    @Override
    public void setListener(MessageProcessor listener) {
        this.next = listener;
    }

    public CachingStrategy getCachingStrategy() {
        return this.cachingStrategy;
    }

    public void setCachingStrategy(CachingStrategy cachingStrategy) {
        this.cachingStrategy = cachingStrategy;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

