/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.CaseInsensitiveHashMap;
import org.mule.util.MapUtils;
import org.mule.util.ObjectUtils;

public class MessagePropertiesContext
implements Serializable {
    private static final long serialVersionUID = -5230693402768953742L;
    private static final PropertyScope DEFAULT_SCOPE = PropertyScope.OUTBOUND;
    private static Log logger = LogFactory.getLog(MessagePropertiesContext.class);
    protected Map<PropertyScope, Map<String, Object>> scopedMap;
    protected transient Map<String, Object> sessionMap = new UndefinedSessionPropertiesMap();
    protected Set<String> keySet = new TreeSet<String>();

    public MessagePropertiesContext() {
        this.scopedMap = new TreeMap<PropertyScope, Map<String, Object>>(new PropertyScope.ScopeComparator());
        this.scopedMap.put(PropertyScope.INVOCATION, (Map<String, Object>)((Object)new CaseInsensitiveHashMap(6)));
        this.scopedMap.put(PropertyScope.INBOUND, (Map<String, Object>)((Object)new CaseInsensitiveHashMap(6)));
        this.scopedMap.put(PropertyScope.OUTBOUND, (Map<String, Object>)((Object)new CaseInsensitiveHashMap(6)));
    }

    protected Map<String, Object> getScopedProperties(PropertyScope scope) {
        if (PropertyScope.SESSION.equals(scope)) {
            return this.sessionMap;
        }
        Map<String, Object> map = this.scopedMap.get(scope);
        if (map == null) {
            throw new IllegalArgumentException("Scope not registered: " + scope);
        }
        return map;
    }

    public PropertyScope getDefaultScope() {
        return DEFAULT_SCOPE;
    }

    protected void addInboundProperties(Map<String, Object> properties) {
        if (properties != null) {
            HashMap<String, Object> props = new HashMap<String, Object>(properties.size());
            for (String key : properties.keySet()) {
                props.put(key, properties.get(key));
            }
            this.getScopedProperties(PropertyScope.INBOUND).putAll(props);
            this.keySet.addAll(props.keySet());
        }
    }

    @Deprecated
    public Object getProperty(String key) {
        return this.getProperty(key, PropertyScope.OUTBOUND);
    }

    public <T> T getProperty(String key, PropertyScope scope) {
        if (scope == null) {
            scope = PropertyScope.OUTBOUND;
        }
        return (T)this.getScopedProperties(scope).get(key);
    }

    public void clearProperties() {
        Map<String, Object> props = this.getScopedProperties(PropertyScope.INVOCATION);
        this.keySet.removeAll(props.keySet());
        props.clear();
        props = this.getScopedProperties(PropertyScope.OUTBOUND);
        this.keySet.removeAll(props.keySet());
        props.clear();
    }

    public void clearProperties(PropertyScope scope) {
        if (scope == null) {
            this.clearProperties();
            return;
        }
        Map<String, Object> props = this.getScopedProperties(scope);
        this.keySet.removeAll(props.keySet());
        props.clear();
    }

    public Object removeProperty(String key) {
        Object value = this.getScopedProperties(PropertyScope.OUTBOUND).remove(key);
        Object inv = this.getScopedProperties(PropertyScope.INVOCATION).remove(key);
        this.keySet.remove(key);
        if (value == null) {
            value = inv;
        }
        return value;
    }

    public Object removeProperty(String key, PropertyScope scope) {
        if (scope == null) {
            return this.removeProperty(key);
        }
        Object value = this.getScopedProperties(scope).remove(key);
        if (this.getProperty(key, PropertyScope.OUTBOUND) == null && this.getProperty(key, PropertyScope.INVOCATION) == null && this.getProperty(key, PropertyScope.INBOUND) == null) {
            this.keySet.remove(key);
        }
        return value;
    }

    @Deprecated
    public void setProperty(String key, Object value) {
        this.getScopedProperties(DEFAULT_SCOPE).put(key, value);
        this.keySet.add(key);
    }

    public void setProperty(String key, Object value, PropertyScope scope) {
        if (!(value instanceof Serializable) && PropertyScope.SESSION.equals(scope)) {
            logger.warn((Object)CoreMessages.sessionPropertyNotSerializableWarning(key));
        }
        this.getScopedProperties(scope).put(key, value);
        this.keySet.add(key);
    }

    @Deprecated
    public Set<String> getPropertyNames() {
        HashSet<String> allProps = new HashSet<String>();
        allProps.addAll(this.keySet);
        return allProps;
    }

    public Set<String> getPropertyNames(PropertyScope scope) {
        return Collections.unmodifiableSet(this.getScopedProperties(scope).keySet());
    }

    protected void checkScopeForWriteAccess(PropertyScope scope) {
        if (scope == null || PropertyScope.INBOUND.equals(scope)) {
            throw new IllegalArgumentException("Scope is invalid for writing properties: " + scope);
        }
    }

    public Object getProperty(String key, Object defaultValue) {
        Object value = this.getProperty(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public byte getByteProperty(String name, byte defaultValue) {
        return ObjectUtils.getByte(this.getProperty(name), defaultValue);
    }

    public short getShortProperty(String name, short defaultValue) {
        return ObjectUtils.getShort(this.getProperty(name), defaultValue);
    }

    public int getIntProperty(String name, int defaultValue) {
        return ObjectUtils.getInt(this.getProperty(name), defaultValue);
    }

    public long getLongProperty(String name, long defaultValue) {
        return ObjectUtils.getLong(this.getProperty(name), defaultValue);
    }

    public float getFloatProperty(String name, float defaultValue) {
        return ObjectUtils.getFloat(this.getProperty(name), defaultValue);
    }

    public double getDoubleProperty(String name, double defaultValue) {
        return ObjectUtils.getDouble(this.getProperty(name), defaultValue);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return ObjectUtils.getBoolean(this.getProperty(name), defaultValue);
    }

    @Deprecated
    public String getStringProperty(String name, String defaultValue) {
        return this.getStringProperty(name, PropertyScope.OUTBOUND, defaultValue);
    }

    public String getStringProperty(String name, PropertyScope scope, String defaultValue) {
        return ObjectUtils.getString(this.getProperty(name, scope), defaultValue);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(128);
        buf.append("Properties{");
        for (Map.Entry<PropertyScope, Map<String, Object>> entry : this.scopedMap.entrySet()) {
            buf.append(entry.getKey()).append(":");
            buf.append(MapUtils.toString(entry.getValue(), false));
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        for (PropertyScope scope : new PropertyScope[]{PropertyScope.INVOCATION, PropertyScope.INBOUND, PropertyScope.OUTBOUND}) {
            for (Map.Entry<String, Object> entry : this.scopedMap.get(scope).entrySet()) {
                Object value = entry.getValue();
                if (value == null || value instanceof Serializable) continue;
                String message = String.format("Unable to serialize the %s message property %s, which is of type %s ", scope, entry.getKey(), value);
                logger.error((Object)message);
                throw new IOException(message);
            }
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.sessionMap = new UndefinedSessionPropertiesMap();
    }

    private static class UndefinedSessionPropertiesMap
    extends AbstractMap<String, Object>
    implements Serializable {
        private static final long serialVersionUID = -7982608304570908737L;

        private UndefinedSessionPropertiesMap() {
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public Object put(String key, Object value) {
            throw new IllegalStateException(String.format("Detected an attempt to set a session property, but a MuleEvent hasn't been created useing this message yet. Key/value: %s=%s", key, value));
        }

        @Override
        public Object get(Object key) {
            logger.warn((Object)String.format("Detected an attempt to get a session property, but a MuleEvent hasn't been created useing this message yet. Key: %s", key));
            return null;
        }
    }
}

