/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.util.queue.DefaultQueueInfoDelegate;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueInfoDelegate;
import org.mule.util.queue.TakingQueueInfoDelegate;

public class QueueInfo {
    private QueueConfiguration config;
    private String name;
    private QueueInfoDelegate delegate;
    private MuleContext muleContext;
    private boolean delegateCanTake;
    private static Map<Class<? extends ObjectStore>, QueueInfoDelegateFactory> delegateFactories = new HashMap<Class<? extends ObjectStore>, QueueInfoDelegateFactory>();

    public QueueInfo(String name, MuleContext muleContext, QueueConfiguration config) {
        this.name = name;
        this.muleContext = muleContext;
        this.setConfigAndDelegate(config);
    }

    public QueueInfo(QueueInfo other) {
        this(other.name, other.muleContext, other.config);
    }

    public void setConfig(QueueConfiguration config) {
        this.setConfigAndDelegate(config);
    }

    private void setConfigAndDelegate(QueueConfiguration config) {
        boolean hadConfig = this.config != null;
        this.config = config;
        int capacity = 0;
        QueueInfoDelegateFactory factory = null;
        if (config != null) {
            capacity = config.capacity;
            factory = delegateFactories.get(config.objectStore.getClass());
        }
        if (this.delegate == null || config != null && !hadConfig) {
            this.delegate = factory != null ? factory.createDelegate(this, this.muleContext) : new DefaultQueueInfoDelegate(capacity);
            this.delegateCanTake = this.delegate instanceof TakingQueueInfoDelegate;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof QueueInfo && this.name.equals(((QueueInfo)obj).name);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void putNow(Serializable o) {
        this.delegate.putNow(o);
    }

    public boolean offer(Serializable o, int room, long timeout) throws InterruptedException, ObjectStoreException {
        return this.delegate.offer(o, room, timeout);
    }

    public Serializable poll(long timeout) throws InterruptedException {
        return this.delegate.poll(timeout);
    }

    public Serializable peek() throws InterruptedException {
        return this.delegate.peek();
    }

    public void untake(Serializable item) throws InterruptedException, ObjectStoreException {
        this.delegate.untake(item);
    }

    public int getSize() {
        return this.delegate.getSize();
    }

    public ListableObjectStore<Serializable> getStore() {
        return this.config == null ? null : this.config.objectStore;
    }

    public static synchronized void registerDelegateFactory(Class<? extends ObjectStore> storeType, QueueInfoDelegateFactory factory) {
        delegateFactories.put(storeType, factory);
    }

    public int getCapacity() {
        return this.config == null ? null : Integer.valueOf(this.config.capacity);
    }

    public boolean canTakeFromStore() {
        return this.delegateCanTake;
    }

    public Serializable takeNextItemFromStore(long timeout) throws InterruptedException {
        if (this.canTakeFromStore()) {
            return ((TakingQueueInfoDelegate)this.delegate).takeFromObjectStore(timeout);
        }
        throw new UnsupportedOperationException("Method 'takeNextItemFromStore' is not supported for queue " + this.name);
    }

    public void writeToObjectStore(Serializable data) throws InterruptedException, ObjectStoreException {
        if (this.canTakeFromStore()) {
            ((TakingQueueInfoDelegate)this.delegate).writeToObjectStore(data);
            return;
        }
        throw new UnsupportedOperationException("Method 'writeToObjectStore' is not supported for queue " + this.name);
    }

    public static interface QueueInfoDelegateFactory {
        public QueueInfoDelegate createDelegate(QueueInfo var1, MuleContext var2);
    }
}

