/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.net.Socket;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.TimedSocket;

public final class NetworkUtils {
    private static final Log logger = LogFactory.getLog(NetworkUtils.class);

    private NetworkUtils() {
    }

    public static boolean isServerReachable(URL url, int timeout) {
        int port = url.getPort() != -1 ? url.getPort() : url.getDefaultPort();
        return NetworkUtils.isServerReachable(url.getHost(), port, timeout);
    }

    public static boolean isServerReachable(String host, int port, int timeout) {
        boolean isServerReachable = false;
        Socket socket = null;
        try {
            socket = TimedSocket.createSocket(host, port, timeout);
            isServerReachable = true;
        }
        catch (Exception e) {
            logger.debug((Object)("Server at " + host + ":" + port + " not reachable. " + e.getMessage()));
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception socketNotClosed) {
                logger.debug((Object)socketNotClosed);
            }
        }
        return isServerReachable;
    }
}

