/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;

public class ValueExtractorTransformer
extends AbstractMessageTransformer {
    public static final String DEFAULT_SOURCE_EXPRESSION = "#[payload:]";
    private String source = "#[payload:]";
    private List<ValueExtractorTemplate> valueExtractorTemplates;

    @Override
    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        String valueToMatch = this.getValueToMatch(message);
        for (ValueExtractorTemplate valueExtractorTemplate : this.valueExtractorTemplates) {
            Matcher matcher = valueExtractorTemplate.compiledPattern.matcher(valueToMatch);
            if (matcher.matches()) {
                if (matcher.groupCount() != 1) {
                    throw new IllegalStateException("Matched regular expression must contain one capture group but contains " + matcher.groupCount());
                }
                this.muleContext.getExpressionManager().enrich(valueExtractorTemplate.getTarget(), message, matcher.group(1));
                continue;
            }
            if (valueExtractorTemplate.failIfNoMatch) {
                throw new IllegalStateException(String.format("Source value '%s' does not math pattern '%s'", valueToMatch, valueExtractorTemplate.getPattern()));
            }
            if (valueExtractorTemplate.defaultValue == null) continue;
            this.muleContext.getExpressionManager().enrich(valueExtractorTemplate.getTarget(), message, valueExtractorTemplate.defaultValue);
        }
        return message;
    }

    private String getValueToMatch(MuleMessage message) {
        if (this.muleContext.getExpressionManager().isValidExpression(this.source)) {
            Object result = this.muleContext.getExpressionManager().evaluate(this.source, message, true);
            if (result instanceof String) {
                return (String)result;
            }
            throw new IllegalArgumentException("String value expected but received value is " + result.getClass().getName());
        }
        return this.source;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public List<ValueExtractorTemplate> getValueExtractorTemplates() {
        return Collections.unmodifiableList(this.valueExtractorTemplates);
    }

    public void setValueExtractorTemplates(List<ValueExtractorTemplate> ValueExtractorTemplates) {
        this.valueExtractorTemplates = ValueExtractorTemplates;
    }

    public static class ValueExtractorTemplate {
        private String pattern;
        private String target;
        private boolean failIfNoMatch;
        private Pattern compiledPattern;
        private String defaultValue;

        public ValueExtractorTemplate() {
        }

        public ValueExtractorTemplate(String pattern, String target, boolean failIfNoMatch, String defaultValue) {
            this.defaultValue = defaultValue;
            this.setPattern(pattern);
            this.target = target;
            this.failIfNoMatch = failIfNoMatch;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
            this.compiledPattern = Pattern.compile(pattern);
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public boolean isFailIfNoMatch() {
            return this.failIfNoMatch;
        }

        public void setFailIfNoMatch(boolean failIfNoMatch) {
            this.failIfNoMatch = failIfNoMatch;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }
    }
}

