/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.exception.RollbackSourceCallback;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.exception.AbstractExceptionStrategy;
import org.mule.message.DefaultExceptionPayload;
import org.mule.transport.AbstractConnector;
import org.mule.transport.ConnectException;

public class AbstractSystemExceptionStrategy
extends AbstractExceptionStrategy
implements SystemExceptionHandler {
    public AbstractSystemExceptionStrategy(MuleContext muleContext) {
        super(muleContext);
    }

    @Override
    public void handleException(Exception ex, RollbackSourceCallback rollbackMethod) {
        this.fireNotification(ex);
        this.logException(ex);
        if (this.isRollback(ex)) {
            this.logger.debug((Object)"Rolling back transaction");
            this.rollback(rollbackMethod);
        } else {
            this.logger.debug((Object)"Committing transaction");
            this.commit();
        }
        DefaultExceptionPayload exceptionPayload = new DefaultExceptionPayload(ex);
        if (RequestContext.getEvent() != null) {
            RequestContext.setExceptionPayload(exceptionPayload);
        }
        if (ex instanceof ConnectException) {
            this.handleReconnection((ConnectException)ex);
        }
    }

    @Override
    public void handleException(Exception ex) {
        this.handleException(ex, null);
    }

    protected void handleReconnection(ConnectException ex) {
        AbstractConnector connector = (AbstractConnector)ex.getFailed();
        if (connector.isConnecting()) {
            return;
        }
        this.logger.info((Object)"Exception caught is a ConnectException, attempting to reconnect...");
        try {
            this.logger.debug((Object)("Disconnecting " + connector.getName()));
            connector.stop();
            connector.disconnect();
        }
        catch (Exception e1) {
            this.logger.error((Object)e1.getMessage());
        }
        try {
            this.logger.debug((Object)("Reconnecting " + connector.getName()));
            connector.connect();
            connector.start();
        }
        catch (Exception e2) {
            this.logger.error((Object)e2.getMessage());
        }
    }
}

