/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats.printers;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.management.stats.RouterStatistics;
import org.mule.management.stats.SedaServiceStatistics;
import org.mule.management.stats.ServiceStatistics;

public class AbstractTablePrinter
extends PrintWriter {
    public AbstractTablePrinter(Writer out) {
        super(out, true);
    }

    public AbstractTablePrinter(OutputStream out) {
        super(out, true);
    }

    public String[] getHeaders() {
        String[] column = new String[]{"Name", "Service Pool Max Size", "Service Pool Size", "Thread Pool Size", "Current Queue Size", "Max Queue Size", "Avg Queue Size", "Sync Events Received", "Async Events Received", "Total Events Received", "Sync Events Sent", "Async Events Sent", "ReplyTo Events Sent", "Total Events Sent", "Executed Events", "Execution Messages", "Fatal Messages", "Min Execution Time", "Max Execution Time", "Avg Execution Time", "Total Execution Time", "Processed Events", "Min Processing Time", "Max Processing Time", "Avg Processing Time", "Total Processing Time", "In Router Statistics", "Total Received", "Total Routed", "Not Routed", "Caught Events", "By Provider", "", "Out Router Statistics", "Total Received", "Total Routed", "Not Routed", "Caught Events", "By Provider", "", "Sample Period"};
        return column;
    }

    protected void getColumn(FlowConstructStatistics stats, String[] col) {
        if (stats == null) {
            return;
        }
        ServiceStatistics serviceStats = stats instanceof ServiceStatistics ? (ServiceStatistics)stats : null;
        Arrays.fill(col, "-");
        col[0] = stats.getName();
        if (stats instanceof SedaServiceStatistics) {
            col[1] = ((SedaServiceStatistics)stats).getComponentPoolMaxSize() + "/" + ((SedaServiceStatistics)stats).getComponentPoolAbsoluteMaxSize();
            col[2] = String.valueOf(((SedaServiceStatistics)stats).getComponentPoolSize());
        } else {
            col[1] = "-";
            col[2] = "-";
        }
        col[3] = String.valueOf(stats.getThreadPoolSize());
        if (serviceStats != null) {
            col[4] = String.valueOf(serviceStats.getQueuedEvents());
            col[5] = String.valueOf(serviceStats.getMaxQueueSize());
            col[6] = String.valueOf(serviceStats.getAverageQueueSize());
        }
        col[7] = String.valueOf(stats.getSyncEventsReceived());
        col[8] = String.valueOf(stats.getAsyncEventsReceived());
        col[9] = String.valueOf(stats.getTotalEventsReceived());
        if (serviceStats != null) {
            col[10] = String.valueOf(serviceStats.getSyncEventsSent());
            col[11] = String.valueOf(serviceStats.getAsyncEventsSent());
            col[12] = String.valueOf(serviceStats.getReplyToEventsSent());
            col[13] = String.valueOf(serviceStats.getTotalEventsSent());
        }
        if (serviceStats != null) {
            col[14] = String.valueOf(serviceStats.getExecutedEvents());
        }
        col[15] = String.valueOf(stats.getExecutionErrors());
        col[16] = String.valueOf(stats.getFatalErrors());
        if (serviceStats != null) {
            col[17] = String.valueOf(serviceStats.getMinExecutionTime());
            col[18] = String.valueOf(serviceStats.getMaxExecutionTime());
            col[19] = String.valueOf(serviceStats.getAverageExecutionTime());
            col[20] = String.valueOf(serviceStats.getTotalExecutionTime());
        }
        col[21] = String.valueOf(stats.getProcessedEvents());
        col[22] = String.valueOf(stats.getMinProcessingTime());
        col[23] = String.valueOf(stats.getMaxProcessingTime());
        col[24] = String.valueOf(stats.getAverageProcessingTime());
        col[25] = String.valueOf(stats.getTotalProcessingTime());
        if (serviceStats != null) {
            int i = this.getRouterInfo(serviceStats.getInboundRouterStat(), col, 26);
            i = this.getRouterInfo(serviceStats.getOutboundRouterStat(), col, i);
        }
        col[40] = String.valueOf(stats.getSamplePeriod());
    }

    protected int getRouterInfo(RouterStatistics stats, String[] col, int index) {
        col[index++] = stats.isInbound() ? "-" : "-";
        col[index++] = String.valueOf(stats.getTotalReceived());
        col[index++] = String.valueOf(stats.getTotalRouted());
        col[index++] = String.valueOf(stats.getNotRouted());
        col[index++] = String.valueOf(stats.getCaughtMessages());
        Map routed = stats.getRouted();
        col[index++] = "-";
        if (!routed.isEmpty()) {
            Iterator it = routed.entrySet().iterator();
            StringBuffer buf = new StringBuffer(40);
            while (it.hasNext()) {
                Map.Entry e = it.next();
                buf.append(e.getKey()).append('=').append(e.getValue());
                if (!it.hasNext()) continue;
                buf.append(';');
            }
            col[index++] = buf.toString();
        } else {
            col[index++] = "";
        }
        return index;
    }

    protected String[][] getTable(Collection stats) {
        int i;
        String[] cols = this.getHeaders();
        String[][] table = new String[stats.size() + 1][cols.length];
        for (i = 0; i < cols.length; ++i) {
            table[0][i] = cols[i];
        }
        i = 1;
        Iterator iterator = stats.iterator();
        while (iterator.hasNext()) {
            this.getColumn((FlowConstructStatistics)iterator.next(), table[i]);
            ++i;
        }
        return table;
    }

    @Override
    public void print(Object obj) {
        if (obj instanceof Collection) {
            this.print((Collection)obj);
        } else if (obj instanceof ServiceStatistics) {
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(obj);
            this.print(l);
        } else {
            super.print(obj);
        }
    }

    @Override
    public void println(Object obj) {
        this.print(obj);
        this.println();
    }

    public void print(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void println(String string) {
        this.println((Object)string);
    }

    @Override
    public void print(String string) {
        this.print((Object)string);
    }
}

