/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.work.WorkListener;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManager;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.exception.RollbackSourceCallback;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.api.security.SecurityManager;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.transaction.TransactionManagerFactory;
import org.mule.client.DefaultLocalMuleClient;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.NotificationException;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.exception.DefaultSystemExceptionStrategy;
import org.mule.expression.DefaultExpressionManager;
import org.mule.lifecycle.MuleContextLifecycleManager;
import org.mule.management.stats.AllStatistics;
import org.mule.registry.DefaultRegistryBroker;
import org.mule.registry.MuleRegistryHelper;
import org.mule.transport.DefaultPollingController;
import org.mule.transport.PollingController;
import org.mule.util.ApplicationShutdownSplashScreen;
import org.mule.util.ApplicationStartupSplashScreen;
import org.mule.util.ServerShutdownSplashScreen;
import org.mule.util.ServerStartupSplashScreen;
import org.mule.util.SplashScreen;
import org.mule.util.UUID;
import org.mule.util.queue.QueueManager;

public class DefaultMuleContext
implements MuleContext {
    private transient Log logger = LogFactory.getLog(DefaultMuleContext.class);
    private DefaultRegistryBroker registryBroker;
    private MuleRegistry muleRegistryHelper;
    private AllStatistics stats = new AllStatistics();
    private WorkManager workManager;
    private WorkListener workListener;
    protected MuleContextLifecycleManager lifecycleManager;
    protected ServerNotificationManager notificationManager;
    private MuleConfiguration config;
    private long startDate;
    private ExpressionManager expressionManager;
    private ClassLoader executionClassLoader;
    protected LocalMuleClient localMuleClient;
    protected SystemExceptionHandler exceptionListener;
    private String clusterId = "";
    private int clusterNodeId;
    private PollingController pollingController = new DefaultPollingController();
    private Map<QName, Set<Object>> configurationAnnotations;

    public DefaultMuleContext(MuleConfiguration config, WorkManager workManager, WorkListener workListener, MuleContextLifecycleManager lifecycleManager, ServerNotificationManager notificationManager) {
        this.config = config;
        ((MuleContextAware)((Object)config)).setMuleContext(this);
        this.workManager = workManager;
        this.workListener = workListener;
        this.lifecycleManager = lifecycleManager;
        this.notificationManager = notificationManager;
        this.notificationManager.setMuleContext(this);
        this.expressionManager = new DefaultExpressionManager();
        ((MuleContextAware)((Object)this.expressionManager)).setMuleContext(this);
        this.registryBroker = this.createRegistryBroker();
        this.muleRegistryHelper = this.createRegistryHelper(this.registryBroker);
        this.localMuleClient = new DefaultLocalMuleClient(this);
        this.exceptionListener = new DefaultSystemExceptionStrategy(this);
        this.configurationAnnotations = new HashMap<QName, Set<Object>>();
    }

    protected DefaultRegistryBroker createRegistryBroker() {
        return new DefaultRegistryBroker(this);
    }

    protected MuleRegistry createRegistryHelper(DefaultRegistryBroker registry) {
        return new MuleRegistryHelper(registry, this);
    }

    @Override
    public synchronized void initialise() throws InitialisationException {
        this.lifecycleManager.checkPhase("initialise");
        if (this.getNotificationManager() == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("_muleNotificationManager"));
        }
        if (this.workManager == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("workManager"));
        }
        try {
            this.muleRegistryHelper.initialise();
            if (this.workManager instanceof MuleContextAware) {
                MuleContextAware contextAware = (MuleContextAware)((Object)this.workManager);
                contextAware.setMuleContext(this);
            }
            this.workManager.start();
            this.getNotificationManager().start(this.workManager, this.workListener);
            this.fireNotification(new MuleContextNotification((MuleContext)this, 101));
            this.getLifecycleManager().fireLifecycle("initialise");
            this.fireNotification(new MuleContextNotification((MuleContext)this, 102));
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public synchronized void start() throws MuleException {
        this.getLifecycleManager().checkPhase("start");
        if (this.getSecurityManager() == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("securityManager"));
        }
        if (this.getQueueManager() == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("queueManager"));
        }
        this.startDate = System.currentTimeMillis();
        this.fireNotification(new MuleContextNotification((MuleContext)this, 103));
        this.getLifecycleManager().fireLifecycle("start");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 104));
        if (this.logger.isInfoEnabled()) {
            SplashScreen startupScreen = this.buildStartupSplash();
            this.logger.info((Object)startupScreen.toString());
        }
    }

    @Override
    public synchronized void stop() throws MuleException {
        this.getLifecycleManager().checkPhase("stop");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 105));
        this.getLifecycleManager().fireLifecycle("stop");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 106));
    }

    @Override
    public synchronized void dispose() {
        if (this.isStarted()) {
            try {
                this.stop();
            }
            catch (MuleException e) {
                this.logger.error((Object)"Failed to stop Mule context", (Throwable)e);
            }
        }
        this.getLifecycleManager().checkPhase("dispose");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 107));
        try {
            this.getLifecycleManager().fireLifecycle("dispose");
            this.muleRegistryHelper.dispose();
        }
        catch (Exception e) {
            this.logger.debug((Object)("Failed to cleanly dispose Mule: " + e.getMessage()), (Throwable)e);
        }
        this.notificationManager.fireNotification(new MuleContextNotification((MuleContext)this, 108));
        this.notificationManager.dispose();
        this.workManager.dispose();
        if (this.getStartDate() > 0L && this.logger.isInfoEnabled()) {
            SplashScreen shutdownScreen = this.buildShutdownSplash();
            this.logger.info((Object)shutdownScreen.toString());
        }
        this.setExecutionClassLoader(null);
    }

    @Override
    public boolean isInitialised() {
        return this.getLifecycleManager().getState().isInitialised();
    }

    @Override
    public boolean isInitialising() {
        return this.getLifecycleManager().getState().isInitialising();
    }

    @Override
    public boolean isStopped() {
        return this.getLifecycleManager().getState().isStopped();
    }

    @Override
    public boolean isStopping() {
        return this.getLifecycleManager().getState().isStopping();
    }

    @Override
    public boolean isStarted() {
        return this.getLifecycleManager().isPhaseComplete("start");
    }

    @Override
    public boolean isStarting() {
        return this.getLifecycleManager().getState().isStarting();
    }

    @Override
    public boolean isDisposed() {
        return this.getLifecycleManager().getState().isDisposed();
    }

    @Override
    public boolean isDisposing() {
        return this.getLifecycleManager().getState().isDisposing();
    }

    @Override
    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public AllStatistics getStatistics() {
        return this.stats;
    }

    @Override
    public void registerListener(ServerNotificationListener l) throws NotificationException {
        this.registerListener(l, null);
    }

    @Override
    public void registerListener(ServerNotificationListener l, String resourceIdentifier) throws NotificationException {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager == null) {
            throw new MuleRuntimeException(CoreMessages.serverNotificationManagerNotEnabled());
        }
        notificationManager.addListenerSubscription(l, resourceIdentifier);
    }

    @Override
    public void unregisterListener(ServerNotificationListener l) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.removeListener(l);
        }
    }

    @Override
    public void fireNotification(ServerNotification notification) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.fireNotification(notification);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MuleEvent Manager is not enabled, ignoring notification: " + notification));
        }
    }

    @Override
    public void setSecurityManager(SecurityManager securityManager) throws RegistrationException {
        this.checkLifecycleForPropertySet("_muleSecurityManager", "initialise");
        this.registryBroker.registerObject("_muleSecurityManager", securityManager);
    }

    @Override
    public SecurityManager getSecurityManager() {
        Collection<SecurityManager> temp;
        SecurityManager securityManager = (SecurityManager)this.registryBroker.lookupObject("_muleSecurityManager");
        if (securityManager == null && (temp = this.registryBroker.lookupObjects(SecurityManager.class)).size() > 0) {
            securityManager = temp.iterator().next();
        }
        return securityManager;
    }

    @Override
    public WorkManager getWorkManager() {
        return this.workManager;
    }

    @Override
    public WorkListener getWorkListener() {
        return this.workListener;
    }

    @Override
    public QueueManager getQueueManager() {
        Collection<QueueManager> temp;
        QueueManager queueManager = (QueueManager)this.registryBroker.lookupObject("_muleQueueManager");
        if (queueManager == null && (temp = this.registryBroker.lookupObjects(QueueManager.class)).size() > 0) {
            queueManager = temp.iterator().next();
        }
        return queueManager;
    }

    @Override
    public void setQueueManager(QueueManager queueManager) throws RegistrationException {
        this.checkLifecycleForPropertySet("_muleQueueManager", "initialise");
        this.registryBroker.registerObject("_muleQueueManager", queueManager);
    }

    @Override
    public MuleConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public ServerNotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    @Override
    public void setTransactionManager(TransactionManager manager) throws RegistrationException {
        this.registryBroker.registerObject("_muleTransactionManager", manager);
    }

    @Override
    public TransactionManager getTransactionManager() {
        TransactionManager transactionManager = (TransactionManager)this.registryBroker.lookupObject("_muleTransactionManager");
        if (transactionManager == null) {
            Collection<TransactionManagerFactory> temp = this.registryBroker.lookupObjects(TransactionManagerFactory.class);
            if (temp.size() > 0) {
                try {
                    transactionManager = temp.iterator().next().create(this.config);
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(CoreMessages.failedToCreate("transaction manager"), (Throwable)e);
                }
            } else {
                temp = this.registryBroker.lookupObjects(TransactionManager.class);
                if (temp.size() > 0) {
                    transactionManager = (TransactionManager)temp.iterator().next();
                }
            }
        }
        return transactionManager;
    }

    protected void checkLifecycleForPropertySet(String propertyName, String phase) throws IllegalStateException {
        if (this.lifecycleManager.isPhaseComplete(phase)) {
            throw new IllegalStateException("Cannot set property: '" + propertyName + "' once the server has already been through the " + phase + " phase.");
        }
    }

    @Override
    public MuleRegistry getRegistry() {
        return this.muleRegistryHelper;
    }

    @Override
    public ThreadingProfile getDefaultMessageDispatcherThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultMessageDispatcherThreadingProfile");
    }

    @Override
    public ThreadingProfile getDefaultMessageRequesterThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultMessageRequesterThreadingProfile");
    }

    @Override
    public ThreadingProfile getDefaultMessageReceiverThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultMessageReceiverThreadingProfile");
    }

    @Override
    public ThreadingProfile getDefaultServiceThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultServiceThreadingProfile");
    }

    @Override
    public ThreadingProfile getDefaultThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultThreadingProfile");
    }

    @Override
    public long getStartDate() {
        return this.startDate;
    }

    @Override
    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    @Override
    public void setExecutionClassLoader(ClassLoader cl) {
        this.executionClassLoader = cl;
    }

    @Override
    public ClassLoader getExecutionClassLoader() {
        return this.executionClassLoader;
    }

    @Override
    public void addRegistry(Registry registry) {
        this.registryBroker.addRegistry(registry);
    }

    @Override
    public void removeRegistry(Registry registry) {
        this.registryBroker.removeRegistry(registry);
    }

    protected SplashScreen buildStartupSplash() {
        SplashScreen startupScreen = this.config.isContainerMode() ? new ApplicationStartupSplashScreen() : new ServerStartupSplashScreen();
        startupScreen.setHeader(this);
        startupScreen.setFooter(this);
        return startupScreen;
    }

    protected SplashScreen buildShutdownSplash() {
        SplashScreen shutdownScreen = this.config.isContainerMode() ? new ApplicationShutdownSplashScreen() : new ServerShutdownSplashScreen();
        shutdownScreen.setHeader(this);
        return shutdownScreen;
    }

    @Override
    public LocalMuleClient getClient() {
        return this.localMuleClient;
    }

    @Override
    public void handleException(Exception e, RollbackSourceCallback rollbackMethod) {
        if (e instanceof MessagingException) {
            MuleEvent event = ((MessagingException)e).getEvent();
            event.getFlowConstruct().getExceptionListener().handleException(e, event, rollbackMethod);
        } else {
            this.getExceptionListener().handleException(e, rollbackMethod);
        }
    }

    @Override
    public void handleException(Exception e) {
        this.handleException(e, null);
    }

    @Override
    public SystemExceptionHandler getExceptionListener() {
        return this.exceptionListener;
    }

    @Override
    public void setExceptionListener(SystemExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    @Override
    public EndpointFactory getEndpointFactory() {
        return (EndpointFactory)this.registryBroker.lookupObject("_muleEndpointFactory");
    }

    @Override
    public void setObjectStore(String name, ListableObjectStore<Serializable> store) throws RegistrationException {
        this.checkLifecycleForPropertySet(name, "initialise");
        this.registryBroker.registerObject(name, store);
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    @Override
    public int getClusterNodeId() {
        return this.clusterNodeId;
    }

    public void setClusterNodeId(int clusterNodeId) {
        this.clusterNodeId = clusterNodeId;
    }

    public void setPollingController(PollingController pollingController) {
        this.pollingController = pollingController;
    }

    @Override
    public boolean isPrimaryPollingInstance() {
        return this.pollingController.isPrimaryPollingInstance();
    }

    @Override
    public String getUniqueIdString() {
        return this.clusterNodeId + "-" + UUID.getUUID();
    }

    @Override
    public Map<QName, Set<Object>> getConfigurationAnnotations() {
        return this.configurationAnnotations;
    }
}

