/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStore;
import org.mule.util.queue.DefaultQueueInfoDelegate;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueInfoDelegate;

public class QueueInfo {
    private QueueConfiguration config;
    private String name;
    private QueueInfoDelegate delegate;
    private static Map<Class<? extends ObjectStore>, QueueInfoDelegateFactory> delegateFactories = new HashMap<Class<? extends ObjectStore>, QueueInfoDelegateFactory>();

    public QueueInfo(String name, QueueConfiguration config) {
        this.name = name;
        this.setConfigAndDelegate(config);
    }

    public void setConfig(QueueConfiguration config) {
        this.setConfigAndDelegate(config);
    }

    private void setConfigAndDelegate(QueueConfiguration config) {
        boolean hadConfig = this.config != null;
        this.config = config;
        int capacity = 0;
        QueueInfoDelegateFactory factory = null;
        if (config != null) {
            capacity = config.capacity;
            factory = delegateFactories.get(config.objectStore.getClass());
        }
        if (this.delegate == null || config != null && !hadConfig) {
            this.delegate = factory != null ? factory.createDelegate(this) : new DefaultQueueInfoDelegate(capacity);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof QueueInfo && this.name.equals(((QueueInfo)obj).name);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void putNow(Serializable o) {
        this.delegate.putNow(o);
    }

    public boolean offer(Serializable o, int room, long timeout) throws InterruptedException {
        return this.delegate.offer(o, room, timeout);
    }

    public Serializable poll(long timeout) throws InterruptedException {
        return this.delegate.poll(timeout);
    }

    public Serializable peek() throws InterruptedException {
        return this.delegate.peek();
    }

    public void untake(Serializable item) throws InterruptedException {
        this.delegate.untake(item);
    }

    public int getSize() {
        return this.delegate.getSize();
    }

    public ListableObjectStore<Serializable> getStore() {
        return this.config == null ? null : this.config.objectStore;
    }

    public static synchronized void registerDelegateFactory(Class<? extends ObjectStore> storeType, QueueInfoDelegateFactory factory) {
        delegateFactories.put(storeType, factory);
    }

    public int getCapacity() {
        return this.config == null ? null : Integer.valueOf(this.config.capacity);
    }

    public static interface QueueInfoDelegateFactory {
        public QueueInfoDelegate createDelegate(QueueInfo var1);
    }
}

