/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.text.NumberFormat;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.SimpleDataType;
import org.mule.util.NumberUtils;

public class StringToNumber
extends AbstractTransformer
implements DiscoverableTransformer {
    private NumberFormat numberFormat;
    private int priorityWeighting = 2;

    public StringToNumber() {
        this.registerSourceType(new SimpleDataType(String.class));
        this.setReturnDataType(DataTypeFactory.create(Number.class));
    }

    public StringToNumber(NumberFormat numberFormat) {
        this();
        this.numberFormat = numberFormat;
    }

    @Override
    public Object doTransform(Object src, String encoding) throws TransformerException {
        if (src == null) {
            return null;
        }
        if (this.numberFormat != null) {
            try {
                return NumberUtils.convertNumberToTargetClass(this.numberFormat.parse((String)src), this.getReturnClass());
            }
            catch (Exception e) {
                throw new TransformerException(this, (Throwable)e);
            }
        }
        return NumberUtils.parseNumber((String)src, this.getReturnClass());
    }

    public Class<? extends Number> getReturnClass() {
        return super.getReturnDataType().getType();
    }

    @Override
    public void setReturnDataType(DataType<?> type) {
        if (!Number.class.isAssignableFrom(type.getType())) {
            throw new IllegalArgumentException("This transformer only supports Number return types.");
        }
        super.setReturnDataType(type);
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

