/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;

public class TransformerTemplate
extends AbstractMessageTransformer {
    private TransformerCallback callback;

    public TransformerTemplate(TransformerCallback callback) {
        this.callback = callback;
    }

    @Override
    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        try {
            return this.callback.doTransform(message);
        }
        catch (TransformerException e) {
            throw new TransformerException(e.getI18nMessage(), this, (Throwable)e);
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    public static class OverwitePayloadCallback
    implements TransformerCallback {
        private Object payload;

        public OverwitePayloadCallback(Object payload) {
            this.payload = payload;
        }

        @Override
        public Object doTransform(MuleMessage message) throws Exception {
            return this.payload;
        }
    }

    public static interface TransformerCallback {
        public Object doTransform(MuleMessage var1) throws Exception;
    }
}

