/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.processor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;

public class ServiceLoggingMessageProcessor
implements MessageProcessor {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected Service service;

    public ServiceLoggingMessageProcessor(Service service) {
        this.service = service;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (event.getExchangePattern().hasResponse()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Service: " + this.service.getName() + " has received synchronous event on: " + event.getEndpoint().getEndpointURI()));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Service: " + this.service.getName() + " has received asynchronous event on: " + event.getEndpoint().getEndpointURI()));
        }
        return event;
    }
}

