/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.transaction.TransactionCallback;
import org.mule.api.transaction.TransactionConfig;
import org.mule.config.i18n.CoreMessages;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.transaction.TransactionTemplate;

public class TransactionalInterceptingMessageProcessor
extends AbstractInterceptingMessageProcessor {
    protected TransactionConfig transactionConfig;

    public TransactionalInterceptingMessageProcessor(TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    @Override
    public MuleEvent process(final MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        TransactionTemplate<MuleEvent> tt = new TransactionTemplate<MuleEvent>(this.transactionConfig, event.getMuleContext());
        TransactionCallback<MuleEvent> cb = new TransactionCallback<MuleEvent>(){

            @Override
            public MuleEvent doInTransaction() throws Exception {
                return TransactionalInterceptingMessageProcessor.this.processNext(event);
            }
        };
        try {
            return tt.execute(cb);
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.errorInvokingMessageProcessorWithinTransaction(this.next, this.transactionConfig), event, (Throwable)e);
        }
    }
}

