/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.endpoint.EndpointAware;
import org.mule.processor.AsyncInterceptingMessageProcessor;

public class OptionalAsyncInterceptingMessageProcessor
extends AsyncInterceptingMessageProcessor
implements EndpointAware {
    protected ImmutableEndpoint endpoint;

    public OptionalAsyncInterceptingMessageProcessor(WorkManagerSource workManagerSource) {
        super(workManagerSource);
    }

    @Deprecated
    public OptionalAsyncInterceptingMessageProcessor(WorkManagerSource workManagerSource, boolean doThreading) {
        super(workManagerSource, doThreading);
    }

    public OptionalAsyncInterceptingMessageProcessor(ThreadingProfile threadingProfile, String name, int shutdownTimeout) {
        super(threadingProfile, name, shutdownTimeout);
    }

    @Override
    protected boolean isProcessAsync(MuleEvent event) throws MessagingException {
        boolean isTransacted;
        boolean hasResponse;
        Object messageProperty = event.getMessage().getInboundProperty("MULE_FORCE_SYNC");
        boolean forceSync = Boolean.TRUE.equals(messageProperty);
        if (this.endpoint != null) {
            hasResponse = this.endpoint.getExchangePattern().hasResponse();
            isTransacted = this.endpoint.getTransactionConfig().isTransacted();
        } else {
            hasResponse = event.getExchangePattern().hasResponse();
            isTransacted = event.getEndpoint().getTransactionConfig().isTransacted();
        }
        return !forceSync && this.doThreading && !hasResponse && !isTransacted;
    }

    @Override
    public void setEndpoint(ImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
    }
}

