/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManager;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.processor.AbstractMessageProcessorOwner;
import org.mule.processor.AsyncWorkListener;
import org.mule.work.AbstractMuleEventWork;

public class AsyncDelegateMessageProcessor
extends AbstractMessageProcessorOwner
implements MessageProcessor,
Startable,
Stoppable {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected WorkManagerSource workManagerSource;
    protected boolean doThreading = true;
    protected WorkManager workManager;
    protected MessageProcessor delegate;

    public AsyncDelegateMessageProcessor(ThreadingProfile threadingProfile, String name, int shutdownTimeout) {
        this.doThreading = threadingProfile.isDoThreading();
        this.workManager = threadingProfile.createWorkManager(name, shutdownTimeout);
        this.workManagerSource = new WorkManagerSource(){

            @Override
            public WorkManager getWorkManager() throws MuleException {
                return AsyncDelegateMessageProcessor.this.workManager;
            }
        };
    }

    @Override
    public void start() throws MuleException {
        if (this.workManager != null) {
            this.workManager.start();
        }
        super.start();
    }

    @Override
    public void stop() throws MuleException {
        if (this.workManager != null) {
            this.workManager.dispose();
        }
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (this.delegate != null) {
            try {
                this.workManagerSource.getWorkManager().scheduleWork(new AsyncMessageProcessorWorker(event), Long.MAX_VALUE, null, new AsyncWorkListener(this.delegate));
            }
            catch (Exception e) {
                new MessagingException(CoreMessages.errorSchedulingMessageProcessorForAsyncInvocation(this.delegate), event, (Throwable)e);
            }
        }
        return event;
    }

    public void setDelegate(MessageProcessor delegate) {
        this.delegate = delegate;
    }

    @Override
    protected List<MessageProcessor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.delegate);
    }

    class AsyncMessageProcessorWorker
    extends AbstractMuleEventWork {
        public AsyncMessageProcessorWorker(MuleEvent event) {
            super(event);
        }

        @Override
        protected void doRun() {
            try {
                AsyncDelegateMessageProcessor.this.delegate.process(this.event);
            }
            catch (MuleException e) {
                this.event.getFlowConstruct().getExceptionListener().handleException(e, this.event);
            }
        }
    }
}

