/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.FilterUnacceptedException;
import org.mule.config.i18n.CoreMessages;
import org.mule.processor.AbstractInterceptingMessageProcessor;

public abstract class AbstractFilteringMessageProcessor
extends AbstractInterceptingMessageProcessor {
    protected boolean throwOnUnaccepted = false;
    protected MessageProcessor unacceptedMessageProcessor;

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        if (this.accept(event)) {
            return this.processNext(event);
        }
        return this.handleUnaccepted(event);
    }

    protected abstract boolean accept(MuleEvent var1);

    protected MuleEvent handleUnaccepted(MuleEvent event) throws MuleException {
        if (this.unacceptedMessageProcessor != null) {
            return this.unacceptedMessageProcessor.process(event);
        }
        if (this.throwOnUnaccepted) {
            throw this.filterUnacceptedException(event);
        }
        return null;
    }

    protected MuleException filterUnacceptedException(MuleEvent event) {
        return new FilterUnacceptedException(CoreMessages.messageRejectedByFilter(), event);
    }

    public MessageProcessor getUnacceptedMessageProcessor() {
        return this.unacceptedMessageProcessor;
    }

    public void setUnacceptedMessageProcessor(MessageProcessor unacceptedMessageProcessor) {
        this.unacceptedMessageProcessor = unacceptedMessageProcessor;
    }

    public boolean isThrowOnUnaccepted() {
        return this.throwOnUnaccepted;
    }

    public void setThrowOnUnaccepted(boolean throwOnUnaccepted) {
        this.throwOnUnaccepted = throwOnUnaccepted;
    }
}

