/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.service.Service;
import org.mule.config.i18n.CoreMessages;

public class MuleContextExpressionEvaluator
implements ExpressionEvaluator,
MuleContextAware {
    public static final String NAME = "context";
    protected MuleContext muleContext;

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public Object evaluate(String expression, MuleMessage message) {
        if (expression.equals("serviceName")) {
            return this.getEventContext().getFlowConstruct().getName();
        }
        if (expression.equals("modelName")) {
            if (this.getEventContext().getFlowConstruct() instanceof Service) {
                return ((Service)this.getEventContext().getFlowConstruct()).getModel().getName();
            }
            throw new UnsupportedOperationException("The 'modelName' function can only be used with Service");
        }
        if (expression.equals("inboundEndpoint")) {
            return this.getEventContext().getEndpointURI();
        }
        if (expression.equals("serverId")) {
            return this.getMuleContext().getConfiguration().getId();
        }
        if (expression.equals("clusterId")) {
            return this.getMuleContext().getConfiguration().getClusterId();
        }
        if (expression.equals("domainId")) {
            return this.getMuleContext().getConfiguration().getDomainId();
        }
        if (expression.equals("workingDir")) {
            return this.getMuleContext().getConfiguration().getWorkingDirectory();
        }
        if (expression.equals("homeDir")) {
            return this.getMuleContext().getConfiguration().getMuleHomeDirectory();
        }
        throw new IllegalArgumentException(expression);
    }

    protected MuleContext getMuleContext() {
        return this.muleContext;
    }

    protected MuleEventContext getEventContext() {
        if (RequestContext.getEventContext() == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("MuleEventContext"));
        }
        return RequestContext.getEventContext();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }
}

