/*
 * Decompiled with CFR 0.152.
 */
package org.mule.enricher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.processor.MessageProcessor;
import org.mule.processor.AbstractMessageProcessorOwner;
import org.mule.util.StringUtils;

public class MessageEnricher
extends AbstractMessageProcessorOwner
implements MessageProcessor {
    private List<EnrichExpressionPair> enrichExpressionPairs = new ArrayList<EnrichExpressionPair>();
    private MessageProcessor enrichmentProcessor;

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        ExpressionManager expressionManager = event.getMuleContext().getExpressionManager();
        MuleMessage enrichmentMessage = this.enrichmentProcessor.process(RequestContext.setEvent(event)).getMessage();
        if (enrichmentMessage != null) {
            for (EnrichExpressionPair pair : this.enrichExpressionPairs) {
                this.enrich(event.getMessage(), enrichmentMessage, pair.getSource(), pair.getTarget(), expressionManager);
            }
        }
        return event;
    }

    protected void enrich(MuleMessage currentMessage, MuleMessage enrichmentMessage, String sourceExpressionArg, String targetExpressionArg, ExpressionManager expressionManager) {
        Object enrichmentObject;
        if (StringUtils.isEmpty((String)sourceExpressionArg)) {
            sourceExpressionArg = "#[payload]";
        }
        if ((enrichmentObject = expressionManager.evaluate(sourceExpressionArg, enrichmentMessage)) instanceof MuleMessage) {
            enrichmentObject = ((MuleMessage)enrichmentObject).getPayload();
        }
        if (!StringUtils.isEmpty((String)targetExpressionArg)) {
            expressionManager.enrich(targetExpressionArg, currentMessage, enrichmentObject);
        } else {
            currentMessage.setPayload(enrichmentObject);
        }
    }

    public void setEnrichmentMessageProcessor(MessageProcessor enrichmentProcessor) {
        this.enrichmentProcessor = enrichmentProcessor;
    }

    public void setMessageProcessor(MessageProcessor enrichmentProcessor) {
        this.enrichmentProcessor = enrichmentProcessor;
    }

    public void setEnrichExpressionPairs(List<EnrichExpressionPair> enrichExpressionPairs) {
        this.enrichExpressionPairs = enrichExpressionPairs;
    }

    public void addEnrichExpressionPair(EnrichExpressionPair pair) {
        this.enrichExpressionPairs.add(pair);
    }

    @Override
    protected List<MessageProcessor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.enrichmentProcessor);
    }

    public static class EnrichExpressionPair {
        private String source;
        private String target;

        public EnrichExpressionPair() {
        }

        public EnrichExpressionPair(String target) {
            this.target = target;
        }

        public EnrichExpressionPair(String source, String target) {
            this.source = source;
            this.target = target;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }
    }
}

