/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import java.lang.reflect.Method;
import org.mule.api.MuleEvent;
import org.mule.api.MuleRuntimeException;
import org.mule.api.NameableObject;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.BlockingServerEvent;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.processor.MessageProcessor;
import org.mule.util.ObjectUtils;

public class MessageProcessorNotification
extends ServerNotification
implements BlockingServerEvent {
    private static final long serialVersionUID = 1L;
    public static final int MESSAGE_PROCESSOR_PRE_INVOKE = 1601;
    public static final int MESSAGE_PROCESSOR_POST_INVOKE = 1602;
    private final transient MessageProcessor processor;
    private String messageProcessorName;

    public MessageProcessorNotification(FlowConstruct flowConstruct, MuleEvent event, MessageProcessor processor, int action) {
        super(event, action, flowConstruct != null ? flowConstruct.getName() : null);
        this.processor = processor;
        try {
            try {
                Method method = processor.getClass().getMethod("getName", new Class[0]);
                this.messageProcessorName = ObjectUtils.toString((Object)method.invoke((Object)processor, new Object[0]), (String)this.toString(processor));
            }
            catch (NoSuchMethodException e) {
                this.messageProcessorName = this.toString(processor);
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public MuleEvent getSource() {
        if (this.source instanceof String) {
            return null;
        }
        return (MuleEvent)super.getSource();
    }

    public MessageProcessor getProcessor() {
        return this.processor;
    }

    public String getFriendlyProcessorName() {
        return this.messageProcessorName;
    }

    protected String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        String name = obj instanceof NameableObject ? String.format("%s '%s'", obj.getClass().getName(), ((NameableObject)obj).getName()) : ObjectUtils.identityToString((Object)obj);
        return name;
    }

    static {
        MessageProcessorNotification.registerAction("message processor pre invoke", 1601);
        MessageProcessorNotification.registerAction("message processor post invoke", 1602);
    }
}

