/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import java.io.Serializable;
import org.mule.api.MuleContext;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.construct.Pipeline;
import org.mule.api.store.ListableObjectStore;
import org.mule.config.QueueProfile;
import org.mule.construct.AsynchronousProcessingStrategy;
import org.mule.management.stats.QueueStatistics;
import org.mule.management.stats.QueueStatisticsAware;
import org.mule.processor.AsyncInterceptingMessageProcessor;
import org.mule.processor.SedaStageInterceptingMessageProcessor;
import org.mule.util.concurrent.ThreadNameHelper;

public class QueuedAsynchronousProcessingStrategy
extends AsynchronousProcessingStrategy
implements QueueStatisticsAware {
    protected Integer queueTimeout;
    protected Integer maxQueueSize = 0;
    protected ListableObjectStore<Serializable> queueStore = null;
    protected QueueStatistics queueStatistics;

    @Override
    protected AsyncInterceptingMessageProcessor createAsyncMessageProcessor(Pipeline pipeline) {
        MuleContext muleContext = pipeline.getMuleContext();
        Integer timeout = this.queueTimeout != null ? this.queueTimeout.intValue() : muleContext.getConfiguration().getDefaultQueueTimeout();
        this.initQueueStore(muleContext);
        String threadName = ThreadNameHelper.flow(pipeline.getMuleContext(), pipeline.getName());
        QueueProfile queueProfile = new QueueProfile(this.maxQueueSize, this.queueStore);
        ThreadingProfile threadingProfile = this.createThreadingProfile(muleContext);
        return new SedaStageInterceptingMessageProcessor(threadName, queueProfile, timeout, threadingProfile, this.queueStatistics, muleContext);
    }

    protected void initQueueStore(MuleContext muleContext) {
        this.queueStore = (ListableObjectStore)muleContext.getRegistry().lookupObject("_defaultInMemoryQueueStore");
    }

    public Integer getQueueTimeout() {
        return this.queueTimeout;
    }

    public void setQueueTimeout(Integer queueTimeout) {
        this.queueTimeout = queueTimeout;
    }

    public Integer getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(Integer maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public ListableObjectStore<Serializable> getQueueStore() {
        return this.queueStore;
    }

    public void setQueueStore(ListableObjectStore<Serializable> queueStore) {
        this.queueStore = queueStore;
    }

    public QueueStatistics getQueueStatistics() {
        return this.queueStatistics;
    }

    @Override
    public void setQueueStatistics(QueueStatistics queueStatistics) {
        this.queueStatistics = queueStatistics;
    }
}

