/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import org.mule.DefaultMuleEvent;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.construct.AbstractPipeline;
import org.mule.construct.AsynchronousProcessingStrategy;
import org.mule.construct.QueuedAsynchronousProcessingStrategy;
import org.mule.construct.processor.FlowConstructStatisticsMessageProcessor;
import org.mule.interceptor.ProcessingTimeInterceptor;
import org.mule.lifecycle.processor.ProcessIfStartedMessageProcessor;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.session.DefaultMuleSession;

public class Flow
extends AbstractPipeline
implements MessageProcessor {
    public Flow(String name, MuleContext muleContext) {
        super(name, muleContext);
        this.processingStrategy = new QueuedAsynchronousProcessingStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        DefaultMuleSession calledSession = new DefaultMuleSession(event.getSession(), this);
        DefaultMuleEvent newEvent = new DefaultMuleEvent(event.getMessage(), event.getEndpoint(), event, calledSession);
        RequestContext.setEvent(newEvent);
        try {
            MuleEvent muleEvent = this.pipeline.process(newEvent);
            return muleEvent;
        }
        finally {
            RequestContext.setEvent(event);
        }
    }

    @Override
    protected void configurePreProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        super.configurePreProcessors(builder);
        builder.chain(new ProcessIfStartedMessageProcessor(this, this.getLifecycleState()));
        builder.chain(new ProcessingTimeInterceptor());
        builder.chain(new FlowConstructStatisticsMessageProcessor());
    }

    @Deprecated
    public void setEndpoint(InboundEndpoint endpoint) {
        this.messageSource = endpoint;
    }

    @Override
    public String getConstructType() {
        return "Flow";
    }

    @Override
    protected void configureStatistics() {
        this.statistics = this.processingStrategy instanceof AsynchronousProcessingStrategy && ((AsynchronousProcessingStrategy)this.processingStrategy).getMaxThreads() != null ? new FlowConstructStatistics(this.getConstructType(), this.name, ((AsynchronousProcessingStrategy)this.processingStrategy).getMaxThreads()) : new FlowConstructStatistics(this.getConstructType(), this.name);
        this.statistics.setEnabled(this.muleContext.getStatistics().isEnabled());
        this.muleContext.getStatistics().add(this.statistics);
    }
}

